/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cont.v#1 $
*/

APPS.MultiWindowApp Contour<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Contour shows the use of the contour and external_edges high level macros. Note it is also very easy to add an axis system using the Axis3D macro.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=44.,NEx=275.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.contour contour<NEx=132.,NEy=143.> {
      in_field => Read_UCD.field;
      ContourParam {
         level_min+nres => cache(0.8*in_field.node_data[contour_comp].min+
                                 0.2*in_field.node_data[contour_comp].max);
         level_max+nres => cache(0.2*in_field.node_data[contour_comp].min+
                                 0.8*in_field.node_data[contour_comp].max);
         contour_comp = 0;
         map_comp = {2};
      };
   };
   MODS.external_edges external_edges<NEy=143.,NEx=308.> {
      in_field => Read_UCD.field;
   };
   GEOMS.Axis3D Axis3D<NEy=143.,NEx=495.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=330.,NEx=352.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               contour.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  0.788984,-0.0417538,0.408651,0.,-0.111303,0.830074,0.299706,
0.,-0.395412,-0.316968,0.731038,0.,0.,0.,0.,1.
               };
               xlate = {-0.847957,-1.48429,-0.81961};
            };
         };
      };
   };
};
