/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cont2.v#1 $
*/

APPS.MultiWindowApp Contour_2D<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Contour_2D demonstrates how slice can be used to extract a 2D plane from a 3D field and then have its output processed by the contour macro to generate a 2D contour plot.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=44.,NEx=297.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   GEOMS.FPlane FPlane<NEy=121.,NEx=363.> {
      in => Read_UCD.field;
   };
   MODS.slice slice<NEx=176.,NEy=176.> {
      in_field => Read_UCD.field;
      in_plane => FPlane.out_fld;
      SliceParam {
         component = {0,1,2,3};
      };
   };
   MODS.contour contour<NEx=132.,NEy=253.> {
      in_field => slice.out_fld;
      ContourParam {
         level_min => 1.20;
         level_max => 4.00;
         map_comp = {2};
      };
   };
   MODS.external_edges external_edges<NEy=121.,NEx=561.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=352,NEx=341> {
      Scene {
         Top {
            child_objs => {contour.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  0.738624,-0.417932,0.297497,0.,0.278257,0.764522,0.383168,0.,
-0.430981,-0.222657,0.757242,0.,0.,0.,0.,1.
               };
               xlate = {-0.395847,-1.62453,-2.17228};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
      };
      Scene_Editor {
         View_Editor {
            UI {
               option {
                  do = 1;
               };
            };
         };
         Light_Editor {
            GDlight_edit {
               type = 3;
            };
         };
      };
   };
};
