/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cont2uni.v#1 $
*/

APPS.MultiWindowApp Contour_2D_Unif<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how the contour macro can be used to display contours on a 2D plane. The uniform 2D field is generated through the use of the orthoslice macro which processes the 3D hydrogen dataset.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=264.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=143.,NEx=231.> {
      in_field => Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEy=143.,NEx=418.> {
      in_field => Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GEOMS.Axis3D Axis3D<NEy=143.,NEx=55.> {
      in_field => Read_Field.field;
   };
   MODS.contour contour<NEx=418.,NEy=264.> {
      in_field => orthoslice.out_fld;
      ContourParam {
         level_min => 72.09;
         level_max => 246.99;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=374.,NEx=121.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               bounds.out_obj,contour.out_obj};
            Xform {
               mat = {
                  0.0684797,-0.0449175,0.0474584,0.,0.0268739,0.0820219,0.0388529,
0.,-0.0595624,-0.0146348,0.0720937,0.,0.,0.,0.,1.
               };
               xlate = {-1.00728,-0.782829,-4.83912};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
               RNC {
                  do = 1;
               };
            };
         };
         Light_Editor {
            GDlight_edit {
               type = 0;
            };
         };
      };
   };
};
