/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cont_txt.v#1 $
*/

APPS.MultiWindowApp Contour_Texture<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how you can provide a series of images read with the Read_Image macro to the contour_texture macro. The result is a contour plot with textures mapped to the contour levels. The orthoslice macro is used to select a 2D slice from the 3D volume.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=319.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=121.,NEx=451.> {
      in_field => Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEy=121.,NEx=33.> {
      in_field => Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=396.,NEx=363.> {
      Scene {
         Top {
            child_objs => {bounds.out_obj,
               <-.<-.<-.contour_texture.out_obj};
            Xform {
               mat = {
                  0.0842177,-0.00614338,0.0242668,0.,0.00194731,0.0865218,0.015146,
0.,-0.0249564,-0.0139804,0.0830719,0.,0.,0.,0.,1.
               };
               xlate = {0.258867,-0.991507,
-3.95758};
               ocenter = {31.5,31.5,31.5};
               dcenter = {-0.258867,0.991507,
3.95758};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 961;
                        defaultY = 158;
                     };
                  };
               };
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
   MODS.Read_Image Read_Image<NEx=242.,NEy=121.> {
      read_image_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/image/marble.x";
         };
      };
   };
   MODS.Read_Image Read_Image#1<NEx=330.,NEy=187.> {
      read_image_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/image/avs.x";
         };
      };
   };
   MODS.contour_texture contour_texture<NEx=154.,NEy=286.> {
      in_field => <-.orthoslice.out_fld;
      in_imgs => {
         <-.Read_Image.field,<-.Read_Image#1.field};
      ContourParam {
         level_max => 255.;
      };
   };
};
