/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cyl.v#1 $
*/

APPS.MultiWindowApp Cylinder<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Cylinder shows how you can define cylindrical fields directly in Express. The cyl_field group defines the basic cylinder which is then processed using contour and external_faces to create the geometry that is seen.";
      helpfile = "examples/examples_help.htm";
   };

   Mesh_Cyl_Unif+Node_Data cyl_field<NEcolor1=16711680,NEcolor2=65280,NEportLevels=1,NEx=242.,NEy=44.> {
      ndim = 3;
      dims = {3,10,3};
      nnode_data = 1;
      node_data {
         veclen = 1;
      } = {
         {
            values=
            {
               0.,1.,2.,0.1,1.1,2.1,0.2,1.2,2.2,0.3,1.3,2.3,0.4,1.4,2.4,
0.5,1.5,2.5,0.6,1.6,2.6,0.7,1.7,2.7,0.8,1.8,2.8,0.9,1.9,2.9,0.,1.,2.,0.1,
1.1,2.1,0.2,1.2,2.2,0.3,1.3,2.3,0.4,1.4,2.4,0.5,1.5,2.5,0.6,1.6,2.6,0.7,
1.7,2.7,0.8,1.8,2.8,0.9,1.9,2.9,0.,1.,2.,0.1,1.1,2.1,0.2,1.2,2.2,0.3,1.3,
2.3,0.4,1.4,2.4,0.5,1.5,2.5,0.6,1.6,2.6,0.7,1.7,2.7,0.8,1.8,2.8,0.9,1.9,
2.9
            },,,,,,,,,,
         }};
      nspace = 3;
      points = {1.,0.,0.,2.,3.14,3.};
   };
   MODS.bounds bounds<NEy=121.,NEx=429.> {
      in_field => cyl_field;
      BoundsParam {
         edges = 1;
         imin = 1;
         imax = 1;
         jmin = 1;
         jmax = 1;
         kmin = 1;
         kmax = 1;
         data = 1;
      };
   };
   MODS.contour contour<NEy=121.,NEx=231.> {
      in_field => cyl_field;
   };
   MODS.external_faces external_faces<NEy=209.,NEx=242.> {
      in_field => contour.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=353,NEx=358> {
      Scene {
         Top {
            child_objs => {
               external_faces.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  1.86707,0.144118,-0.742822,0.,0.158386,1.85945,0.758857,0.,
0.739911,-0.761696,1.71197,0.,0.,0.,0.,1.
               };
               xlate = {-3.09944e-06,-2.4624,-3.75};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
