/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/div.v#1 $
*/

APPS.MultiWindowApp Div<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Div is an example to show the use of the divergence macro. The divergence macro is used when you need to calculate the divergence of a vector field. Note the use of the combine_vect macro to create a 3 component node data to be used as input to the divergence computation.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=33.,NEx=242.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };
   MODS.combine_vect combine_vect<NEy=121.,NEx=341.> {
      in_field => Read_UCD.field;
   };
   MODS.divergence divergence<NEy=176.,NEx=341.> {
      in_field => combine_vect.out_fld;
      int comp = 0;
   };
   MODS.isosurface isosurface<NEy=231.,NEx=341.> {
      in_field => divergence.out_fld;
   };
   MODS.external_edges external_edges<NEy=176.,NEx=11.> {
      in_field => Read_UCD.field;
   };
   GEOMS.Axis3D Axis3D<NEy=176.,NEx=176.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=330.,NEx=165.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               external_edges.out_obj,isosurface.out_obj};
            Xform {
               mat = {
                  2.43925,-0.0822239,1.64143,0.,-0.545725,2.73038,0.947743,0.,
-1.55024,-1.09053,2.2491,0.,0.,0.,0.,1.
               };
               xlate = {0.597818,0.397422,0.292876};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
         Light_Editor {
            GDlight_edit {
               type = 3;
            };
         };
      };
   };
};
