/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/edges.v#1 $
*/

APPS.MultiWindowApp Edges<NEdisplayMode="maximized"> {
   UIsummaryPanel Summary_Panel {
      demo_text => "This example demonstrates use of the edges macro.  It can be used to show the internal cell structure of fields that have thousands of cells.";
      helpfile = "examples/examples_help.htm";
   };
   MODS.Read_UCD Read_UCD {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };
   GEOMS.BackgroundFade BackgroundFade;
   MODS.edges edges<NEx=462.,NEy=209.> {
      in_field => <-.Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.BackgroundFade.out_obj,<-.<-.<-.edges.out_obj};
            Xform {
               mat = {
                  2.27496,-0.639502,1.21932,0.,0.0516162,2.39287,1.15871,0.,
-1.37588,-0.967628,2.05955,0.,0.,0.,0.,1.
               };
               xlate = {2.1713,2.31552,2.73341};
               dcenter = {-2.1713,-2.31552,-2.73341};
            };
         };
         Camera {
            Camera {
               perspec = 1;
               front = 1.;
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 396;
                        defaultY = 75;
                     };
                  };
               };
            };
         };
      };
   };
};
