/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/extrude.v#1 $
*/

APPS.MultiWindowApp Extrude_Cells<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Extrude_Cells shows how cells can be extruded according to a cell data value, to give a height aspect to a visualization. This is often used in a geospatial situation as is seen here. Note the example of threshold_cell to threshold the cell data as a preprocessing step.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_USCounties Read_USCounties<NEx=198.,NEy=22.> {
      rd_counties {
         filename = "$XP_PATH<0>/data/gis/uscount";
         state_no = 6;
      };
   };
   MODS.extract_cell_component extract_cell_component<NEx=198.,NEy=88.> {
      in_field => <-.Read_USCounties.out_mesh;
      ExtrCompParam {
         component = 1;
      };
   };
   MODS.threshold_cell threshold_cell<NEx=198.,NEy=165.> {
      in_field => <-.extract_cell_component.out_fld;
      ThreshParam {
         min_value => 50.;
      };
   };
   MODS.extrude_cells extrude_cells<NEx=198.,NEy=253.> {
      in_field => <-.threshold_cell.out_fld;
      ExtrudeParam {
         scale = 0.01;
         shrink = 1;
         scale_factor = 0.9;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=231.,NEy=363.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.extrude_cells.out_obj};
            Xform {
               mat = {
                  0.658418,-0.390456,0.544539,0.,0.661166,0.502545,-0.43909,0.,
-0.108802,0.691002,0.627031,0.,0.,0.,0.,1.
               };
               xlate = {-4.76883,-16.4351,-0.600173};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
               RNC {
                  do = 1;
               };
            };
         };
         Camera_Editor {
            GDcamera_edit {
               front = -88.;
            };
            Perspective {
               do = 1;
            };
         };
      };
   };
};
