/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/fast_arr1.v#1 $
*/

APPS.MultiWindowApp Fast_ARR_1<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=220> {
      demo_text = "This demonstrates the use of some of the \"Fast\" xxx_ARR macros to process arrays of fields. The \"Fast\" macros in the FAST_ARR library are considerably faster than the standard xxx_ARR macros when the arrays contains hundreds of fields, which sometimes occurs in CFD applications.";
      helpfile = "examples/examples_help.htm";
   };

   CFD.Read_PLOT3D read_plot3d<NEx=143.,NEy=22.> {
      ReadPlot3dParam {
         filename_xyz = "$XP_PATH<0>/data/plot3d/multb_x.dat";
         filename_q   = "$XP_PATH<0>/data/plot3d/multb_q.dat";
         trigger = 1;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=209.,NEy=396.> {
      Scene {
         Top {
            child_objs => {bounds_ARR.out_obj,
               isosurface_ARR.out_obj,<-.<-.<-.edges_ARR.out_obj,
               <-.<-.<-.glyph_ARR.out_obj};
            Xform {
               mat = {
                  5.70509,6.00989,6.37466,0.,1.45001,6.85446,-7.75995,0.,
-8.64016,5.11866,2.90687,0.,0.,0.,0.,1.
               };
               xlate = {1.45568,-3.03548,-1.15078};
               ocenter = {0.172945,0.076201,0.281184};
               dcenter = {-1.50035,3.32164,1.46554};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 406;
                        defaultY = 389;
                     };
                  };
               };
            };
         };
      };
   };
   FAST_ARR.bounds_ARR bounds_ARR<NEx=55.,NEy=132.> {
      in_field => <-.read_plot3d.fields;
   };
   FAST_ARR.isosurface_ARR isosurface_ARR<NEx=242.,NEy=121.> {
      in_field => <-.read_plot3d.fields;
      IsoParam {
         iso_component = 4;
         map_component = {1};
         iso_level => -1.7;
      };
   };
   FAST_ARR.downsize_ARR downsize_ARR<NEx=396.,NEy=77.> {
      in_field => <-.read_plot3d.fields;
      DownsizeParam {
         factor0 = 3.;
         factor1 = 3.;
         factor2 = 2.;
      };
      objs {
         in_fields => ;  /* Don't create an array of DataObjects */
      };
   };
   FAST_ARR.edges_ARR edges_ARR<NEx=539.,NEy=176.> {
      in_field => <-.downsize_ARR.out_fld;
   };
   GEOMS.Diamond3D Diamond3D<NEx=638.,NEy=253.>;
   FAST_ARR.glyph_ARR glyph_ARR<NEx=484.,NEy=319.> {
      in_field => <-.downsize_ARR.out_fld;
      in_glyph => <-.Diamond3D.out_fld;
      GlyphParam {
         glyph_comp = 4;
         map_comp = 4;
         scale_comp = 4;
         scale = 0.02;
      };
   };
};
