/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/fast_arr3.v#1 $
*/

APPS.SingleWindowApp Fast_ARR_3<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=280.,NEy=30> {
      demo_text = "This demonstrates the use of some of the \"Fast\" xxx_ARR macros to process arrays of fields. The \"Fast\" macros in the FAST_ARR library are considerably faster than the standard xxx_ARR macros when the arrays contains hundreds of fields, which sometimes occurs in CFD applications.";
      helpfile = "examples/examples_help.htm";
   };

   UI {
      shell {
         x = 72;
         y = 47;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=240.,NEy=230.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds_ARR.out_obj,<-.<-.<-.set_minmax_ARR.out_obj};
            Xform {
               mat = {
                  2.49283,8.00968,-9.1866,0.,-0.123129,9.39283,8.15611,0.,
12.1875,-1.54341,1.96144,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-2.,-8.};
               center = {0.1524,0.0762,0.3048};
            };
         };
      };
   };
   CFD.Read_PLOT3D read_plot3d<NEx=44.,NEy=44.> {
      ReadPlot3dParam {
         filename_xyz = "$XP_PATH<0>/data/plot3d/multb_x.dat";
         filename_q   = "$XP_PATH<0>/data/plot3d/multb_q.dat";
         trigger = 1;
      };
   };
   FAST_ARR.crop_ARR crop_ARR<NEx=143.,NEy=110.> {
      in_field => <-.read_plot3d.fields;
      CropParam {
         max = {5,3,3};
      };
      objs {
         in_fields => ;  /* Don't create an array of DataObjects */
      };
   };
   FAST_ARR.bounds_ARR bounds_ARR<NEx=352.,NEy=170.> {
      in_field => <-.read_plot3d.fields;
      BoundsParam {
         component = 4;
      };
   };
   FAST_ARR.set_minmax_ARR set_minmax_ARR<NEx=33.,NEy=170.> {
      in_field => <-.crop_ARR.out_fld;
      SetMinmaxParam {
         min => 0.;
         max => 2.;
      };
   };
};

