/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/glh_intp.v#1 $
*/

APPS.MultiWindowApp Glyph_Interp<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=350.,NEy=20> {
      demo_text = "This example shows how you can use the interp_data macro to interpolate the node data values across a sampling plane (provided by the FPlane macro) in an input field. The glyph macro is then used to output glyphs at each of the sampling node points.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=22.,NEx=165.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.combine_vect combine_vect<NEy=110.,NEx=231.> {
      in_field => Read_UCD.field;
      CombineVectParam {
         components = {1,2,3};
      };
   };
   GEOMS.FPlane FPlane<NEy=110.,NEx=473.> {
      in => Read_UCD.field;
   };
   GEOMS.Diamond3D Diamond3D<NEy=198.,NEx=484.>;
   MODS.interp_data interp_data<NEy=187.,NEx=231.> {
      in_field => combine_vect.out_fld;
      in_probe => FPlane.out_fld;
   };
   MODS.glyph glyph<NEy=264.,NEx=231.> {
      in_field => interp_data.out_fld;
      in_glyph => Diamond3D.out_fld;
      GlyphParam {
         scale = 0.26;
      };
   };
   MODS.external_edges external_edges<NEy=110.,NEx=11.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=352.,NEx=99.> {
      Scene {
         Top {
            child_objs => {glyph.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  0.717403,-0.00188759,0.481053,0.,-0.155475,0.816489,0.235066,
0.,-0.45524,-0.281825,0.677801,0.,0.,0.,0.,1.
               };
               xlate = {-0.894083,-1.62297,
-1.02846};
            };
         };
      };
   };
};
