/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/grad.v#1 $
*/

APPS.MultiWindowApp Grad<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "The Grad example shows how to use the gradient macro to compute the gradient of a vector field. Note the use of interp_data to generate node data based on a sampling plane provided by an FPlane macro. A glyph macro is used to visually plot the values of the gradient computed.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=11.,NEx=209.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };
   GEOMS.FPlane Plane<NEy=88,NEx=550> {
      in => Read_UCD.field;
   };
   GEOMS.Arrow1 Arrow1<NEy=220.,NEx=429.>;
   MODS.interp_data interp_data<NEy=110.,NEx=264.> {
      in_field => Read_UCD.field;
      in_probe => Plane.out_fld;
   };
   MODS.gradient gradient<NEy=220.,NEx=253.> {
      in_field => interp_data.out_fld;
   };
   MODS.glyph glyph<NEy=319.,NEx=286.> {
      in_field => gradient.out_fld;
      in_glyph => Arrow1.out_fld;
   };
   GEOMS.Axis3D Axis3D<NEy=99.,NEx=55.> {
      in_field => Read_UCD.field;
   };
   MODS.external_edges external_edges<NEy=165.,NEx=583.> {
      in_field => Plane.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=451.,NEx=154.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               glyph.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  1.4541,-0.173384,1.11753,0.,-0.103943,1.79213,0.413297,0.,
-1.12611,-0.389304,1.40487,0.,0.,0.,0.,1.
               };
               xlate = {-2.38419e-07,-1.19209e-06,
0.221052};
            };
         };
      };
   };
};
