/*
        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/il_sphalo.v#1 $
*/

APPS.MultiWindowApp ILineSpiralHalo<NEdisplayMode="maximized",disabled => Templates.CONFIG.gd_gl_disabled,NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example demonstrates the illuminated lines technique. This is where the OpenGL API is exploited through the use of texture mapping on lines. Effectively, this technique allows animation effects to be created by changing the uv coordinates of the texture map. Because modern day graphics cards are usually optimized for texture mapping this is a very fast technique. The effect is achieved through the use of the illuminated_lines macro.";
      helpfile = "examples/examples_help.htm";
      UItext.rows = 12;
   };

   MODS.Read_UCD Read_UCD {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };

   GEOMS.BackgroundFade BackgroundFade;

   MODS.external_edges external_edges {
      in_field => <-.Read_UCD.field;
   };

   MODS.combine_vect combine_vect {
      in_field => <-.Read_UCD.field;
      CombineVectParam {
         components = {3,4,5};
      };
   };

   GEOMS.FPlane FPlane {
      in => <-.Read_UCD.field;
      dim1 = 30;
      dim2 = 9;
      plane {
         xform {
            xlate = {0.,0.,0.};
            mat   = {0.138919,0.,-0.787846,0.,0.,0.8,0.,
                     0.,0.787846,0.,0.138919,0., 0.,0.,0.,1.
            };
         };
      };
   };
   MODS.streamlines streamlines {
      in_field => <-.combine_vect.out_fld;
      in_probe => <-.FPlane.out_fld;
      StreamUI.ribbon_toggle.active = 0;
      StreamParam {
         order = 3;
         nseg = 3;
         color = 0;
         min_vel = 0.;
         max_seg = 76;
      };
   };
   MODS.magnitude magnitude {
      in_field => <-.streamlines.out_fld;
   };

   DV_OGL.illuminated_lines illuminated_lines {
      in_mesh => <-.magnitude.out_fld;
        ilineParam {
            IlluminationModel {
                Blend = 0.6;
            };
            HaloModel {
                lineWidth = 6;
                haloWidth = 1;
                doSmoothShade = 1;
            };
            AnimationEffect {
                effectLength = 2;
                effectSpacing = 6;
                StairDash = 1;
            };
        };
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.BackgroundFade.out_obj,
               <-.<-.<-.external_edges.out_obj,
               <-.<-.<-.illuminated_lines.obj};
            Xform {
               mat = {
                  5.47251,-1.53835,2.93312,0.,0.124165,5.75615,2.78732,0.,
-3.30974,-2.32767,4.95434,0.,0.,0.,0.,1.
               };
               xlate = {2.54332,2.91488, 2.73341};
               dcenter = {-2.1713,-2.31552, -2.73341};
            };
         };
         Lights {
            LightInfo {
               show_lights = 1;
            };
         };
         Camera {
            Camera {
               perspec = 1;
               front = 1.;
               auto_norm = "None";
            };
         };
      };
   };
};
