/*
        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/il_spnl.v#1 $
*/

APPS.MultiWindowApp ILineSpiralNoLight<NEdisplayMode="maximized",disabled => Templates.CONFIG.gd_gl_disabled,NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example demonstrates the illuminated lines technique. This is where the OpenGL API is exploited through the use of texture mapping on lines. Effectively, this technique allows animation effects to be created by changing the uv coordinates of the texture map. Because modern day graphics cards are usually optimized for texture mapping this is a very fast technique. The effect is achieved through the use of the illuminated_lines macro.";
      helpfile = "examples/examples_help.htm";
      UItext.rows = 12;
   };

   MODS.Read_UCD Read_UCD {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };

   GEOMS.BackgroundFade BackgroundFade {
      params {
         Upper_Left_Green = 0.35;
         Upper_Left_Blue = 0.;
         Upper_Right_Green = 0.47;
         Upper_Right_Blue = 0.73;
         Lower_Left_Red = 0.5;
         Lower_Left_Green = 0.18;
         Lower_Left_Blue = 0.37;
         Lower_Right_Blue = 0.52;
         Upper_Left_Red = 0.45;
         Upper_Right_Red = 0.28;
      };
   };

   MODS.external_edges external_edges {
      in_field => <-.Read_UCD.field;
   };

   MODS.combine_vect combine_vect {
      in_field => <-.Read_UCD.field;
      CombineVectParam {
         components = {3,4,5};
      };
   };

   GEOMS.FPlane FPlane {
      in => <-.Read_UCD.field;
      dim1 = 11;
      dim2 = 2;
      plane {
         xform {
            xlate = {0.,0.,0.};
            mat   = {0.,0.,-0.8,0.,0.,0.8,0.,0.,0.8,0.,0.,0.,0.,0.,0.,1.};
         };
      };
   };

   MODS.streamlines streamlines {
      in_field => <-.combine_vect.out_fld;
      in_probe => <-.FPlane.out_fld;
      StreamUI.ribbon_toggle.active = 0;
      StreamParam {
         order = 1;
         nseg = 5;
         max_seg = 145;
      };
   };

   MODS.magnitude magnitude {
      in_field => <-.streamlines.out_fld;
   };

   DV_OGL.illuminated_lines illuminated_lines {
      in_mesh => <-.magnitude.out_fld;
      ilineParam {
         IlluminationModel {
            Blend = 1.;
         };
         HaloModel {
            lineWidth = 8;
            haloWidth = 0;
            doDepthMask = 1;
            doAntialiasHalo = 1;
            doSmoothShade = 0;
         };
         AnimationEffect {
            animationOn = 1;
            StairDash = 0;
            StairType = 0;
            effectLength = 7;
            effectSpacing = 0;
            TranspWidth = 1;
          };
      };
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.BackgroundFade.out_obj,
               <-.<-.<-.external_edges.out_obj,
               <-.<-.<-.illuminated_lines.obj};
            Xform {
               mat = {
                  2.4979,-2.27969,2.24344,0.,0.199942,2.95224,2.77734,0.,
-3.19217,-1.59894,1.92945,0.,0.,0.,0.,1.
               };
               xlate = {2.54332,2.91488, 2.73341};
               dcenter = {-2.1713,-2.31552, -2.73341};
            };
         };
         Lights {
             Lights = {
                 {
                     state=0
                 }
             };
         };
         Camera {
            Camera {
               perspec = 1;
               front = 1.;
               auto_norm = "None";
            };
         };
      };
   };
};
