/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/intrptxt.v#1 $
*/

APPS.MultiWindowApp Interp_Texture3D<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

  UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows you how you can texture map an arbitrarily shaped region (in this case a geometry defined by the teapot) of a 3D volume using the interp_texture3D macro.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=44.,NEx=121.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.Read_Geom Read_Geom<NEx=308.,NEy=44.> {
      read_geom_ui {
         filename = "$XP_PATH<0>/data/geom/teapot.geo";
      };
      ACread_geom {
         out_field {
            xform {
               xlate = {32.,32.,32.};
               mat = {
                  10.,0.,0.,0.,0.,10.,0.,0.,0.,0.,10.,0.,0.,0.,0.,1.
               };
            };
         };
      };
   };
   MODS.bounds bounds<NEy=143.,NEx=11.> {
      in_field => Read_Field.field;
   };
   DATAS.colormap colormap<NEy=143.,NEx=352.>;
   MODS.interp_texture3D interp_texture3D<NEy=209.,NEx=220.> {
      texture_map => colormap;
      in_field => Read_Field.field;
      in_probe => Read_Geom.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=352.,NEx=143.> {
      Scene {
         Top {
            child_objs => {
               interp_texture3D.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0977474,-0.0148407,0.0312638,0.,0.0304417,0.0814286,-0.0565235,
0.,-0.0164613,0.0624609,0.0811165,0.,0.,0.,0.,1.
               };
               xlate = {-3.51942,-4.06504,
-1.75949};
            };
         };
         View {
            View {
               renderer => 0;
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
         View_Editor {
            GDview_edit {
               renderer = 0;
            };
            UI {
               option {
                  do = 1;
               };
            };
            IUI {
               General {
                  IUI {
                     Renderer {
                        OPcmdList = {
                           
                           {
                              set=1
                           },
                           ,,,
                        };
                     };
                  };
               };
            };
         };
      };
   };
};
