/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/intrpu.v#1 $
*/

APPS.MultiWindowApp Interp_Unif<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=11.,NEy=209.> {
      demo_text = "Interp_Unif shows how you can interpolate the values for 1 volumetric field based upon the coordinates provided by a sample field. In this case, interp_data is used to interpolate the node data values at positions defined by the teapot dataset inside of the hydrogen dataset";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=99.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.Read_Geom Read_Geom<NEx=319.,NEy=33.> {
      read_geom_ui {
         filename = "$XP_PATH<0>/data/geom/teapot.geo";
      };
      ACread_geom {
         out_field {
            xform {
               xlate = {32.,32.,32.};
               mat = {
                  5.,0.,0.,0.,0.,5.,0.,0.,0.,0.,5.,0.,0.,0.,0.,1.
               };
            };
         };
      };
   };
   MODS.bounds bounds<NEy=121.,NEx=11.> {
      in_field => Read_Field.field;
   };
   MODS.interp_data interp_data<NEy=121.,NEx=209.> {
      in_field => Read_Field.field;
      in_probe => Read_Geom.field;
    };
   GDM.Uviewer3D Uviewer3D<NEy=275.,NEx=154.> {
      Scene {
         Top {
            child_objs => {
               interp_data.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0827519,0.0160697,0.0387402,0.,0.0191923,0.0616859,-0.0665838,
0.,-0.037292,0.0674057,0.0516981,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
