/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isonest_1.v#1 $
*/

APPS.MultiWindowApp IsoNest_Unif <NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows a set of nested isosurface shells.  Each isosurface shell is transparent, which allows you to see the inner shells inside the outer shells. The total effect is a bit like volume rendering, but unlike volme rendering, this technique can be used on almost any type of input field.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };

   MODS.downsize downsize {
      in_field => <-.Read_Field.field;
      DownsizeParam {
         factor0 = 2.;
         factor1 = 2.;
         factor2 = 2.;
      };
   };
   MODS.bounds bounds {
      in_field => <-.downsize.out_fld;
   };
   MODS.isosurface_nest isosurface_nest {
      in_field => <-.downsize.out_fld;
      isonest_params {
         num_levels = 5;
         min = 40.;
         max = 200.;
      };
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {<-.<-.<-.bounds.out_obj,
                           <-.<-.<-.isosurface_nest.obj};
         };
         Lights {
            LightXform = {
               {mat=
                  {
                     1.36416,0.392224,-1.1742,0.,0.890771,0.902386,1.33632,0.,
0.859709,-1.55736,0.478582,0.,0.,0.,0.,1.
                  },},
               ,,};
         };
         Camera {
            Camera {
               perspec = 1;
               front = 1.;
            };
         };
      };
   };

};
