/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/m1_fld.v#1 $
*/

APPS.MultiWindowApp Multistep_Field <NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text => "This example shows reading a time-dependent (multi-step) structured field from a .fld file. Only the node data varies over time - the coordinate data does not change.  Note the use of the set_minmax macro to ensure that the colormap is the same for all of the time steps.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEx=583.,NEy=99.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/cylinder.fld";
      };
      Read_Field_Param {
         store_all_steps = 1;
      };
      TextTitle {
         text<NEdisplayMode="open"> {
            background<NEdisplayMode="open"> = 1;
         };
      };
   };
   MODS.set_minmax set_minmax<NEx=528.,NEy=198.> {
      in_field => <-.Read_Field.field;
      SetMinmaxParam {
         max => 10.;
         min => -10.;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=638.,NEy=308.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.set_minmax.out_obj,<-.<-.<-.Read_Field.title_obj};
            Modes {
               mode = {0,2,0,0,0};
            };
            Xform {
               mat = {
                  3.9951,0.,0.,0.,0.,3.9951,0.,0.,0.,0.,3.9951,0.,0.,0.,
0.,1.
               };
               xlate = {3.2781,-0.220884,0.};
               dcenter = {1.48094,0.,0.};
               ocenter = {1.84061,0.,0.};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 504;
                        defaultHeight = 527;
                        defaultX = 387;
                        defaultY = 355;
                     };
                  };
               };
            };
            View {
               trigger = 1;
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
      };
      Scene_Editor {
         Object_Editor {
            GDmodes_edit {
               lines = "Regular";
            };
         };
      };
   };
};
