/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/mblock.v#1 $
*/

APPS.MultiWindowApp Multi_Block<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "This illustrates how you create a typical multi block network. This is basically where you have an array of spatially connected fields and you want to combine them into a multi_block object to perform some global processing. In this example, the stream_multi_block macro is used to create streamlines across the array of fields that have been combined into a multi_block object.";
      helpfile = "examples/examples_help.htm";
   };

   CFD.Read_PLOT3D read_plot3d<NEx=220.,NEy=22.> {
      ReadPlot3dParam {
         filename_xyz = "$XP_PATH<0>/data/plot3d/multb_x.dat";
         filename_q   = "$XP_PATH<0>/data/plot3d/multb_q.dat";
         trigger = 1;
      };
   };
   MODS.stream_multi_block stream_multi_block<NEx=99,NEy=308> {
      in_field => <-.fields_to_mblock.multi_block;
      in_probe => <-.FPlane.out_fld;
   };
   GEOMS.FPlane FPlane<NEx=209,NEy=187> {
      in => <-.read_plot3d.mblock;
      plane {
         xform {
            xlate = {0.,0.,0.04};
         };
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=352,NEy=374> {
      Scene {
         Top {
            child_objs => {
               stream_multi_block.out_obj,bounds_ARR.out_obj,
               isosurface_ARR.out_obj};
            Xform {
               mat = {
                  8.23928,8.67947,9.20627,0.,2.09411,9.89919,-11.2069,0.,
-12.4781,7.39236,4.1981,0.,0.,0.,0.,1.
               };
               xlate = {-5.71429,-2.91667,-11.6648};
            };
         };
      };
   };
   MODS_ARR.combine_vect_ARR combine_vect_ARR<NEx=55,NEy=88> {
      in_field => <-.read_plot3d.fields;
      CombineVectParam {
         components = {1,2,3};
      };
   };
   MODS.fields_to_mblock fields_to_mblock<NEx=33,NEy=187> {
      fields => <-.combine_vect_ARR.out_fld;
   };
   MODS_ARR.bounds_ARR bounds_ARR<NEx=396,NEy=187> {
      in_field => <-.read_plot3d.fields;
   };
   MODS_ARR.isosurface_ARR isosurface_ARR<NEx=363,NEy=99> {
      in_field => <-.read_plot3d.fields;
      IsoParam {
         iso_component = 4;
         map_component = {1};
         iso_level = -1.7;
      };
   };
};
