//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/nc_ex_str.v#1 $

APPS.SingleWindowApp NetCDF_Ex_Structured<NEdisplayMode="maximized",disabled => Templates.CONFIG.netcdf_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   UI {
      shell {
         x = 10;
         y = 10;
      };
      Modules {
         IUI {
            optionList {
               selectedItem = 0;
            };
         };
      };
   };

   UIsummaryPanel Summary_Panel<NEx=352.,NEy=66.> {
      UIlabel {
         label = "netCDF Structured Field Example";
         height => UIdata.UIfonts[0].lineHeight;
      };
      demo_text = "This example shows the netCDF reader being used to read a 2D (3x2) structured field with node data. \n\nThe source code for the program used to create the netCDF file can be found in the src/netcdf/examp directory." ;
      helpfile = "examples/examples_help.htm";
   };

   NETCDF.Read_Field Rd_netCDF_Fld<NEx=77.,NEy=66.> {
      Read_NetCDF_Param {
         filename = "$XP_PATH<0>/data/netCDF/examp_struct.nc";
         selectedVariables = {0};
         trigger = 1;
      };
   };

   MODS.bounds bounds<NEx=33.,NEy=187.> {
      in_field => <-.Rd_netCDF_Fld.field;
      BoundsParam {
         edges = 1;
         imin = 1;
         imax = 1;
         jmin = 1;
         jmax = 1;
         kmin = 1;
         kmax = 1;
      };
   };

   GDM.Uviewer3D Uviewer3D<NEx=253.,NEy=297.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,
               <-.<-.<-.Rd_netCDF_Fld.out_obj};
         };
      };
   };

};
