//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/nc_snow.v#1 $

APPS.SingleWindowApp NetCDF_SnowCover<NEdisplayMode="maximized",disabled => Templates.CONFIG.netcdf_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      UIlabel.label = "AVS/Express netCDF SnowCover Example";
      demo_text = "This is example to shows how scientific data can be downloaded straight from the web and imported directly into Express. The netCDF reader inside Express is used to facilitate this. Note also the use of the data_math module to rescale the data that is displayed into a more meaningful format. Using data_math is often a very convenient method for rescaling your data and/or applying standard mathematical procedures to it before it is visualized.\n\nThis snowcover data is provided by the NOAA-CIRES Climate Diagnostics Center (www.cdc.noaa.gov).";
      UItext {
#ifdef MSDOS
         rows = 16;
#else
         rows = 19;
#endif
      };
      helpfile = "examples/examples_help.htm";
   };

   UI {
      shell {
         x = 36;
         y = 27;
      };
   };
   NETCDF.Read_Field Rd_netCDF_Fld {
      Read_NetCDF_Param {
         timeEnable = 1;
         filename = "$XP_PATH<0>/data/netCDF/snowcover.nc";
         trigger = 1;
         selectedVariables = {0};
      };
      read_netcdf_ui {
         title_label {
            height => 2*UIdata.UIfonts[0].lineHeight;
         };
         hist_label {
            height => 4*UIdata.UIfonts[0].lineHeight;
         };
      };
   };
   GDM.Uviewer2D Uviewer2D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,
               <-.<-.<-.set_null.out_obj,
               <-.<-.<-.LegendHoriz.GroupObject.obj,
               <-.<-.<-.TextTitle.DefaultObject};
         };
      };
   };
   GEOMS.LegendHoriz LegendHoriz {
      obj_in => <-.set_null.out_obj;
   };

   MODS.set_null set_null {
         in_field => <-.data_math.out_fld;
   };
   MODS.bounds bounds {
	 in_field => <-.Rd_netCDF_Fld.field;
   };

   MODS.data_math data_math {
	 in_field1 => <-.Rd_netCDF_Fld.field;
	 expres = "#1 /100.0 + 302.66";
   };

   string months<NEportLevels=1>[12] = {
      "January","February","March","April","May","June","July","August",
      "September","October","November","December"
   };
   string month<NEportLevels=1> => months[.Rd_netCDF_Fld.Read_NetCDF_Param.timeStep];

   GEOMS.TextTitle TextTitle {
      TextUI {
         String {
            text => str_format("Percentage Snowcover\n for %s",<-.<-.<-.month);
         };
         Font {
            text = "-adobe-times-bold-r-*-*-30-*-*-*-*-*-*-*";
         };
      };
   };
};
