/*
	This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/plane_crop.v#1 $
*/

APPS.SingleWindowApp Plane_Crop<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows how to use the plane_crop macro. The macro plane_crop subsets a field by outputting all whole cells that are inside or outside a volume created by an unlimited number of slice planes. Note the use of the extract_component macro to specify which node component to use as the one to visualize as colour.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/bluntfin.fld";
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   GEOMS.Plane Plane {
      plane {
         xform {
            mat = {
               2.95442,0.,-0.520945,0.,0.260472,2.59808,1.47721,0.,0.451151,
-1.5,2.55861,0.,0.,0.,0.,1.
            };
         };
      };
   };
   MODS.extract_component extract_component {
      in_field => <-.Read_Field.field;
      ExtrCompParam {
         component = 1;
      };
   };
   MODS.plane_crop plane_crop {
      in_field => <-.extract_component.out_fld;
      in_plane => {<-.Plane.out_fld};
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,
               <-.<-.<-.Plane.out_obj,
               <-.<-.<-.plane_crop.out_obj};
            Xform {
               ocenter = {3.27323,4.16378,2.86213};
               dcenter = {1.78902,1.81913,1.04357};
               mat = {
                  -0.254532,0.108744,-0.342517,0.,0.0370934,0.425436,0.107504,
0.,0.357445,0.0332858,-0.255057,0.,0.,0.,0.,1.
               };
               xlate = {-1.78902,-1.81913,-1.04357};
            };
         };
      };
   };
};
