/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/probe.v#1 $
*/

APPS.MultiWindowApp Probe<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "Probe shows how the probe macro is used. You make a selection by using <CTRL>LMB, the selection point being highlighted with the cross geometry provided by the Cross3D macro.  If you switch to the probe UI by using the Modules menu, you will be able to see the probed value";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=22.,NEx=308.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   GEOMS.Cross3D Cross3D<NEy=198.,NEx=396.>;
   GEOMS.Axis3D Axis3D<NEy=110.,NEx=22.> {
      in_field => Read_UCD.field;
   };
   MODS.isosurface isosurface<NEy=110.,NEx=396.> {
      in_field => Read_UCD.field;
   };
   MODS.external_edges external_edges<NEy=110.,NEx=187.> {
      in_field => Read_UCD.field;
   };
   MODS.probe probe<NEy=308.,NEx=319.> {
      in_field => Read_UCD.field;
      in_glyph => Cross3D.out_fld;
      in_pick => Uviewer3D.Scene.View.View.picked_obj;
   };
   GDM.Uviewer3D Uviewer3D<NEy=374.,NEx=110.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               isosurface.out_obj,external_edges.out_obj,probe.out_obj};
            Xform {
               mat = {
                  0.651077,-0.00372921,0.561822,0.,-0.247577,0.770057,0.292021,
0.,-0.504344,-0.382827,0.581927,0.,0.,0.,0.,1.
               };
               xlate = {-0.706977,-1.69552,
-1.34896};
            };
         };
      };
   };
};
