/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/quad2.v#1 $
*/

APPS.SingleWindowApp Quad2<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the use of the File Access objects to read files, Field Mappers to map raw arrays to a field and the construction of a quad2 mesh. Note the use of the combine_mesh_data macro to add a node data component to the field created by the quad2_mesh object.";
      helpfile = "examples/examples_help.htm";
   };
   UI {
      shell {
         x = 316;
         y = 106;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=286.,NEy=418.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.external_edges.out_obj,<-.<-.<-.isoline.out_obj,
               <-.<-.<-.contour.out_obj,<-.<-.<-.solid_contour.out_obj};
            Xform {
               mat = {
                  0.421053,0.,0.,0.,0.,0.421053,0.,0.,0.,0.,0.421053,0.,
0.,0.,0.,1.
               };
               xlate = {-4.,-4.,0.};
            };
         };
         View {
            View {
               trigger = 1;
            };
         };
      };
   };
   macro read_quad2_files<NEx=242.,NEy=33.> {
      module rd_coord<data_import_module=1,NEdisplayMode="open",NEx=77.,NEy=99.> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/quad2/coord.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/quad2/*.dat";
            };
         };
         float coord[] => cache(file_obj(.FILE,0,4,{1,1},0,1));
         float xy<NEportLevels={0,3},NEdisplayMode="open">[(array_size(.coord) / 2)][2] => .coord;
      };
      module rd_conn<data_import_module=1> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/quad2/conn.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/quad2/*.dat";
            };
         };
         int connectivity<NEportLevels={0,3}>[] => cache(file_obj(.FILE,0,3,{
                  1,1,1,1,1,1,1,1
               },0,1));
      };
      module rd_data<data_import_module=1> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/quad2/data.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/quad2/*.dat";
            };
         };
         float data<NEportLevels={0,3}>[] => cache(file_obj(.FILE,0,4,{1},0,1));
      };
   };
   FLD_MAP.quad2_mesh quad2_mesh<NEx=132.,NEy=132.> {
      coord => <-.read_quad2_files.rd_coord.xy;
      connect => <-.read_quad2_files.rd_conn.connectivity;
   };
   FLD_MAP.node_scalar node_scalar<NEx=407.,NEy=121.> {
      in_data => <-.read_quad2_files.rd_data.data;
   };
   FLD_MAP.combine_mesh_data combine_mesh_data<NEx=264.,NEy=209.> {
      in_mesh => <-.quad2_mesh.out;
      in_nd => <-.node_scalar.out;
   };
   MODS.external_edges external_edges<NEx=319.,NEy=286.> {
      in_field => <-.combine_mesh_data.out;
      edge_angle = 2.83;
   };
   MODS.isoline isoline<NEx=143.,NEy=286.> {
      in_field => <-.combine_mesh_data.out;
   };
   MODS.contour contour<NEx=506.,NEy=275.> {
      in_field => <-.combine_mesh_data.out;
      ContourParam {
         level_min => 483.85;
         level_max => 714.44;
      };
   };
   MODS.solid_contour solid_contour<NEx=671.,NEy=275.> {
      in_field => <-.combine_mesh_data.out;
      ContourParam {
         level_min => 49.14;
         level_max => 177.66;
      };
   };
};
