/*
                        Copyright (c) 1999 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/reduct2.v#1 $
*/

APPS.MultiWindowApp Reduct_DataSurfaceReduction<NEdisplayMode="maximized", disabled => (Templates.CONFIG.reduct_kit_disabled | Templates.CONFIG.hdf5_kit_disabled)> {

   UIsummaryPanel Summary_Panel<NEx=300.,NEy=44.> {
      demo_text = "This example shows the use of the data_surface_reduction macro. If you select Modules->data_surface_reduction you will see the control panel for the reduction algorithm. If you select Data Dependance->Gradient you will see a better preservation of the striations in the simplified mesh.";
      helpfile = "examples/examples_help.htm";
      UIlabel.height => 3 * UIdata.UIfonts[0].lineHeight;
   };

   GDM.Uviewer3D Uviewer3D<NEx=99.,NEy=253.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Read_HDF5_Field.out_obj};
            Xform {
               dcenter = {-0.273146,-0.922482,0.0584063};
               mat = {
                  34.3956,34.8442,-1.70198,0.,34.8845,-34.3339,2.07913,0.,
0.285974,-2.67168,-48.9167,0.,0.,0.,0.,1.
               };
               xlate = {-0.450262,0.189639,-0.0226102};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 406;
                        defaultHeight = 406;
                        defaultX = 390;
                        defaultY = 0;
                     };
                  };
               };
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
      };
      Scene_Selector {
         input_views => {<-.Scene.View.View,
            <-.Scene#1.View.View};
      };
      GDM.Uscene3D Scene#1<NEx=484.,NEy=77.> {
         Top {
            child_objs<NEportLevels={4,1}> => {
               <-.<-.<-.data_surface_reduction.obj};
            Xform {
               ocenter = {0.021032,-1.95e-05,-7.00075e-06};
               dcenter = {0.170667,-0.481693,-0.0447601};
               mat = {
                  34.7318,34.6063,6.80628,0.,35.2161,-34.5516,-4.02815,0.,
1.93478,7.66871,-48.8636,0.,0.,0.,0.,1.
               };
               xlate = {-0.170667,0.481694,0.04476};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 406;
                        defaultHeight = 406;
                        defaultX = 390;
                        defaultY = 480;
                     };
                  };
               };
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
      };
   };
   HDF5.Rd_HDF5_Field Read_HDF5_Field<NEx=44.,NEy=44.> {
      Rd_HDF5_Param {
         filename = "$XP_PATH<0>/data/hdf5/almond.h5";
         selNodeVars = {0};
         trigger = 1;
      };
   };
   RDCT.data_surface_reduction data_surface_reduction<NEx=66.,NEy=99.> {
      in => <-.Read_HDF5_Field.out_fld;
      DataSurfRedParams {
         ReductionTarget = 70.;
         Weight = 0.25;
         Mode = "Dynamic";
      };
   };
};

