/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/sct2tet.v#1 $
*/

APPS.MultiWindowApp Scat_to_Tet<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=60.> {
      demo_text = "This examples shows how to use the scat_to_tri macro. The scat_to_tri macro converts a scattered grid into triangular or tetrahedral unstructured mesh. Note the use of external_edges to create the visualization seen in the viewer.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=33.,NEx=165.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.scat_to_tri scat_to_tri<NEy=110.,NEx=165.> {
      in_field => Read_UCD.field;
   };
   MODS.external_edges external_edges<NEy=198.,NEx=165.> {
      in_field => scat_to_tri.out_fld;
      edge_angle = 0.;
   };
   GDM.Uviewer3D Uviewer3D<NEy=286.,NEx=165.> {
      Scene {
         Top {
            child_objs => {
               external_edges.out_obj};
            Xform {
               mat = {
                  0.749051,-0.301422,0.472774,0.,0.0449918,0.818716,0.450696,
0.,-0.55888,-0.338078,0.669929,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
