/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/segm_edtr_1.v#1 $
*/

APPS.MultiWindowApp SegmentationEditor<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

    UIsummaryPanel Summary_Panel {
        demo_text = "The Segmentation Editor provides a means for isolating and extracting regions of interest from larger volumes of data. The Segmentation Editor is interactive, so to do much with this demo, you will have to switch to the Segmentation Editor user interface by using the Modules pull down menu, above.  Start by using right mouse clicks in the 'Draw Mask Input' window to begin defining a region of interest in a single 2D slice. Next, use the plane slider to switch slices and define the region of interest in the new slice. The full 3D mask is shown in the 'Mask 3D' window and the final output field is shown in the 'Segmentation Editor Output' window.";
        helpfile = "examples/examples_help.htm";
        UItext.rows = 16;
    };

    MODS.Read_Field Read_Field {
        read_field_ui {
            filename = "$XP_PATH<0>/data/field/hydrogen.fld";
        };
        DVread_field {
            Mesh_Unif+Node_Data Output_Field;
        };
    };

    SEGM_EDTR.SegmentationEditor SegmentationEditor {
        in => <-.Read_Field.field;
        View => <-.Uviewer2D.Scene.View.View;
        params {
            axis = 2;
            slice = 20;
            drawcommand = "Draw Point";
            pen = "Draw";
            width = 10;
            value = 4;
        };
    };

    GDM.Uviewer2D Uviewer2D {
        Scene {
            Top {
                child_objs => {
                    <-.<-.<-.SegmentationEditor.mask_obj};
            };
            View {
                View<NEportLevels={0,4}> {
                    // SW renderer doesn't do transparenry correctly
                    renderer = "OpenGL";
                };
                ViewUI {
                    PickInteractor {
                        startEvent = "<Btn3Down>";
                        runEvent   = "<Btn3Motion>";
                        stopEvent  = "<Btn3Up>";
                    };
                    ViewPanel {
                        UI.option.label => "Draw Mask Input";
                    };
                };
            };
        };
        Scene_Selector {
            input_views => {
                Scene.View.View, <-.Scene#1.View.View, <-.Scene#2.View.View
            };
        };
        GDM.Uscene3D Scene#1 {
            Top {
                child_objs<NEportLevels={4,1}> => {
                    <-.<-.<-.SegmentationEditor.obj};
                Xform {
                    mat = {
                        0.0721697,-0.00520662,-0.0328195,0.,
                        -0.00371893,0.0767125,-0.0203477,0.,
                        0.0330211,0.020019,0.0694375,0.,
                        0.,0.,0.,1.
                    };
                };
            };
            View {
                ViewUI {
                    ViewPanel {
                        UI.option.label => "Segmentation Editor Output";
                    };
                };
            };
        };
        GDM.Uscene3D Scene#2 {
            Top {
                child_objs<NEportLevels={4,1}> => {
                    <-.<-.<-.SegmentationEditor.mask3D_obj};
                Xform {
                    mat = {
                        0.0721697,-0.00520662,-0.0328195,0.,
                        -0.00371893,0.0767125,-0.0203477,0.,
                        0.0330211,0.020019,0.0694375,0.,
                        0.,0.,0.,1.
                    };
                };
            };
            View {
                ViewUI {
                    ViewPanel {
                        UI.option.label => "Mask 3D";
                    };
                };
            };
        };
    };
};
