/*
        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/shrink.v#1 $
*/

APPS.MultiWindowApp Shrink_Cells<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "This example shows how to use the shrink cells macro. The shrink_cells macro produces a mesh with cells shrunk relative to their geometric centers. Note the use of the BackgroundFade macro to get the background effect in the viewer.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEx=176.,NEy=88.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.shrink_cells shrink_cells<NEx=204.,NEy=231.> {
      in_field => <-.Read_UCD.field;
      obj {
         Modes {
            normals = 1;
         };
      };
   };
   GEOMS.BackgroundFade BackgroundFade<NEx=66.,NEy=180.>;

   GDM.Uviewer3D Uviewer3D<NEx=165.,NEy=363.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.shrink_cells.out_obj,<-.<-.<-.BackgroundFade.out_obj};
            Xform {
               mat = {
                  0.90302,0.252836,0.103559,0.,-0.271459,0.870815,0.241011,0.,
-0.030998,-0.26048,0.906248,0.,0.,0.,0.,1.
               };
               xlate = {-1.14342,-2.20809,-1.47794};
            };
         };
      };
   };
};
