/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/slice.v#1 $
*/

APPS.MultiWindowApp Slice<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEy=22.,NEx=300.> {
      demo_text = "Slice is an example of how top create arbitrary positioned slices in a volume. Using the slice macro, you can position the slice interactively in the viewer by selecting it with <CTRL>LMB and then rotating it. Note the use of FPlane to create the plane on which to perform the slice.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=22.,NEx=121.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   GEOMS.FPlane FPlane<NEy=99.,NEx=297.> {
      in => Read_UCD.field;
   };
   MODS.slice slice<NEx=154.,NEy=154.> {
      in_field => Read_UCD.field;
      in_plane => FPlane.out_fld;
   };
   MODS.external_edges external_edges<NEy=231.,NEx=55.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=319.,NEx=308.> {
      Scene {
         Top {
            child_objs => {slice.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  -0.668993,0.471885,0.453013,0.,0.370962,0.807385,-0.293198,0.,
-0.53878,-0.0300291,-0.764371,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
