/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/sol_con.v#1 $
*/

APPS.MultiWindowApp Solid_Contour<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=350.,NEy=33.> {
      demo_text = "Solid_Contour shows the functionality and use of the solid_contour macro. This creates multiple 2D or 3D solid contours and, optionally, overlays them with isolines.  Note the multiple outputs from solid_contour";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=165.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=132.,NEx=407.> {
      in_field => Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEy=132.,NEx=209.> {
      in_field => Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GEOMS.Axis3D Axis3D<NEy=132.,NEx=22.> {
      in_field => Read_Field.field;
   };
   MODS.solid_contour solid_contour<NEx=209.,NEy=231.> {
      in_field => orthoslice.out_fld;
      ContourParam {
         level_max => 255.;
	 contour_lines = 1;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=385.,NEx=121.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               bounds.out_obj,solid_contour.out_obj, solid_contour.out_obj_line};
            Xform {
               mat = {
                  0.0798149,0.0174071,0.0515392,0.,-0.0315995,0.0893252,0.0187667,
0.,-0.0442805,-0.0323684,0.0795062,0.,0.,0.,0.,1.
               };
               xlate = {-4.03905,-4.07518,-4.29509};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
