/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/sphere.v#1 $
*/

APPS.MultiWindowApp Sphere<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=300.,NEy=33.> {
      demo_text = "Sphere shows how you can create a spherical field with Express. The spher_field object contains all the definition for the object rendered in the viewer. Look at the points parameter which is set to {1,0,0,2,3.14,3.14}. The last 3 elements represent radius, theta and phi.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=99.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   Node_Data+Mesh_Spher_Unif spher_field<NEcolor1=16711680,NEportLevels=1,NEx=88.,NEy=88.> {
      ndim = 3;
      dims = {64,64,64};
      nspace = 3;
      points = {1.,0.,0.,2.,3.14,3.14};
      nnode_data = 1;
      &node_data<NEportLevels={2,0}> => Read_Field.field.node_data;
   };
   MODS.bounds bounds<NEy=132.,NEx=330.> {
      in_field => spher_field;
      BoundsParam {
         edges = 1;
         imin = 1;
         imax = 1;
         kmin = 1;
         kmax = 1;
         data = 1;
      };
   };
   MODS.isosurface isosurface<NEy=220.,NEx=132.> {
      in_field => spher_field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=319.,NEx=308.> {
      Scene {
         Top {
            child_objs => {isosurface.out_obj,
               bounds.out_obj};
            Xform {
               mat = {
                  2.02631,0.0092122,1.46547,0.,-0.272754,2.45935,0.361678,0.,
-1.4399,-0.452903,1.99379,0.,0.,0.,0.,1.
               };
               xlate = {-3.33786e-06,-2.49927,-3.33786e-06};
            };
         };
      };
   };
};
