/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/stream.v#1 $
*/

APPS.MultiWindowApp Stream<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "This example shows the streamlines macro. The combine_vect macro is used to comstruct vector node data (veclen == 3) from an initial field that has multiple scalar node data (veclen == 1) components. The FPlane macro provides the initial sample points.  If you switch to the UI of the FPlane macro and increase its dimensions, then the number of streamlines will increase.";
      helpfile = "examples/examples_help.htm";
      UItext.rows = 10;
   };

   MODS.Read_UCD Read_UCD<NEy=66,NEx=341> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.combine_vect combine_vect<NEy=154,NEx=308> {
      in_field => Read_UCD.field;
      CombineVectParam {
         components = {1,2,3};
      };
   };
   GEOMS.FPlane FPlane<NEy=176,NEx=462> {
      in => Read_UCD.field;
      dim1 = 10;
      dim2 = 14;
   };
   MODS.streamlines streamlines<NEy=264,NEx=330> {
      in_field => combine_vect.out_fld;
      in_probe => FPlane.out_fld;
   };
   MODS.external_edges external_edges<NEy=154,NEx=154> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=341,NEx=286> {
      Scene {
         Top {
            child_objs => {
               streamlines.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  0.72217,-0.290004,0.39336,0.,0.178822,0.809997,0.26887,0.,
-0.454816,-0.142007,0.730301,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
