/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/surf_opt.v#1 $
*/

APPS.MultiWindowApp Surface_Optimize<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the functionality and use of the surf_optimize macro. The surf_optimize macro produces an optimized (in terms of biggest possible triangles) triangular mesh from a 2D uniform elevation data field.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEx=99.,NEy=44.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/helens1.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.downsize downsize<NEx=99.,NEy=110.> {
      in_field => <-.Read_Field.field;
      DownsizeParam {
         factor0 = 4.;
         factor1 = 4.;
      };
   };
   MODS.surf_optimize surf_optimize<NEx=187.,NEy=176.> {
      in_field => <-.downsize.out_fld;
   };
   MODS.surf_plot surf_plot<NEx=187.,NEy=242.> {
      in_field => <-.surf_optimize.out_fld;
      SurfPlotParam {
         scale = 0.07;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=253.,NEy=341.> {
      Scene {
         Top {
            child_objs => {surf_plot.out_obj};
            Xform {
               mat = {
                  0.0156398,0.00213229,-0.0147424,0.,-0.0148408,0.00406599,-0.0151561,
0.,0.00127904,0.0211047,0.00440941,0.,0.,0.,0.,1.
               };
               xlate = {-3.52052,-5.,-2.06674};
            };
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = 0;
            };
         };
      };
   };
};
