/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/thresh.v#1 $
*/

APPS.MultiWindowApp Threshold<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "Threshold shows the use of the threshold macro. The threshold macro removes data below and/or above min/max threshold level by setting data to NULL. Once the NULL values are set these are taken into account by downstream modules, in this case the slice macro.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=55,NEx=341> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.threshold threshold<NEy=132.,NEx=374.> {
      in_field => Read_UCD.field;
      ThreshParam {
         min_value => 0.83;
      };
   };
   MODS.external_edges external_edges<NEy=132.,NEx=198.> {
      in_field => Read_UCD.field;
   };
   GEOMS.FPlane FPlane<NEy=132.,NEx=528.> {
      in => Read_UCD.field;
   };
   MODS.slice slice<NEy=253.,NEx=396.> {
      in_field => threshold.out_fld;
      in_plane => FPlane.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=363,NEx=308> {
      Scene {
         Top {
            child_objs => {slice.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  -0.765927,0.35244,0.405696,0.,0.180098,0.833834,-0.384362,0.,
-0.506329,-0.23655,-0.750416,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
