/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/tile_roi.v#1 $
*/

APPS.MultiWindowApp Tile_ROI<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "This example shows the use of the copy_ROI and tile_ROIs macros. First click 2 points on the 2D viewer using the RMB to define a rectangle. Then, select Modules->copy_ROI and click the Run toggle. This generates ROI's for the entire volume in the input field. The ROI's for each slice are now displayed in the Scene#1 viewer.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Readers.Read_Field Read_Field<NEx=429,NEy=44> {
      read_field_ui {
         file_browser<NEx=11,NEy=187> {
            filename = "$XP_PATH<0>/data/field/hydrogen.fld";
         };
      };
   };
   MODS.Mappers.orthoslice orthoslice<NEx=308,NEy=99> {
      in_field => <-.Read_Field.field;
   };
   MODS.Filters.reset_xform reset_xform<NEx=319,NEy=165> {
      in_field => <-.orthoslice.out_fld;
   };
   GDM.Interactivity.ClickSketch ClickSketch<NEx=220,NEy=297> {
      view_in => Uviewer2D.Scene_Selector.curr_view;
      obj_in => reset_xform.out_obj;
      click_sketch {
         GDroi2d_click<NEx=319,NEy=407> {
            option = 2;
            immed = 1;
         };
      };
   };
   MODS.Mappers.copy_ROI copy_ROI<NEx=539,NEy=253> {
      FieldIn => <-.Read_Field.field;
      MeshIn => <-.ClickSketch.click_sketch.GDmap2d_ss.out_mesh;
      MeshOut {
         width = 4;
         height = 3;
      };
      loop {
         count = 63;
      };
      UIfieldTypein#1 {
         field<NEx=11,NEy=143> {
            value = 63;
         };
      };
   };
   MODS.Mappers.tile_ROIs tile_ROIs<NEx=550,NEy=319> {
      Mesh_Array => <-.copy_ROI.DVswitch.out;
   };

   GDM.Uviewer2D Uviewer2D<NEx=517.,NEy=451.> {
      Scene {
         Top {
            child_objs => {reset_xform.out_obj,ClickSketch.click_sketch.DataObject.obj};
         };
      };
      GDM.Uscene3D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {tile_ROIs.DataObject.obj};
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View,
            <-.Scene#1.View.View};
      };
   };
};
