/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/time_dat.v#1 $
*/

APPS.MultiWindowApp Time_Data<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "Time_Data shows how to set up a field with a time dependance and then interpolate coordinate steps using iterp_time_step. The interp_time_step macro constructs a new field by interpolating between existing members of a time sequence of fields. It works on the mesh, node data, and cell data of the input fields.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D<NEx=363.,NEy=484.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.external_edges.out_obj,<-.<-.<-.external_edges#1.out_obj,
               <-.<-.<-.interp_time_step.out_obj};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = -54;
                        defaultY = 106;
                     };
                  };
               };
            };
         };
      };
   };
   Cells+Xform time_field<NEnumColors=4,NEcolor0=255,NEx=253.,NEy=22.,NEportLevels={0,1}> {
      int nnodes = 3;
      int nspace = 2;
      int nsteps = 2;
      double time[.nsteps] = {100.,200.};
      group time_coordinates[.nsteps] {
         double+nres time => <-.time[index_of(<-.time_coordinates)];
         int nnodes => <-.nnodes;
         int nspace => <-.nspace;
         Data_Array coordinates {
            nvals => <-.nnodes;
            veclen => <-.nspace;
            float values[nvals][.veclen];
            float min => cache(min_array(magnitude(.values),0,0));
            float max => cache(max_array(magnitude(.values),0,0));
            float min_vec[.veclen] => cache(min_array(.values,0,0));
            float max_vec[.veclen] => cache(max_array(.values,0,0));
         };
      } = {
         {coordinates=
            {
               values={0.,0.,1.,0.,0.,1.},,,,,,,,,,,
            },,,},
         {coordinates=
            {
               values={0.,0.,0.,1.,-1.,0.},,,,,,,,,,,
            },,,}};
      int nnode_data = 1;
      Node_Data time_node_data<NEcolor2=65280>[.nsteps] {
         nnodes => <-.nnodes;
         nnode_data => <-.nnode_data;
         node_data {
            values+float;
            null_value+float;
            min+float;
            max+float;
            min_vec+float;
            max_vec+float;
         };
         double+nres time => <-.time[index_of(<-.time_node_data)];
      } = {
         {node_data=
            {
               {
                  veclen=1,values={0.,1.,2.},,,,,,,,,,
               }},,,},
         {node_data=
            {
               {
                  veclen=1,values={9.,8.,7.},,,,,,,,,,
               }},,,}};
      ncell_sets = 1;
      Tri cell_set {
         ncells = 1;
         int ncell_data = 1;
         int nsteps = 2;
         double time[.nsteps] = {100.,200.};
         Cell_Data_Set time_cell_data<NEcolor2=65280>[.nsteps] {
            ncells => <-.ncells;
            ncell_data => <-.ncell_data;
            cell_data {
               values+float;
               null_value+float;
               min+float;
               max+float;
               min_vec+float;
               max_vec+float;
            };
            double+nres time => <-.time[index_of(<-.time_cell_data)];
         } = {
            {cell_data=
               {
                  {
                     veclen=1,values=
                     {1.},,,,,,,,,,
                  }},,,},
            {cell_data=
               {
                  {
                     veclen=1,values=
                     {9.},,,,,,,,,,
                  }},,,}};
         node_connect_list = {0,1,2};
      };
   };
   MODS.set_global_extent set_global_extent<NEx=132.,NEy=99.> {
      in_field => <-.time_field;
   };
   MODS.set_global_minmax set_global_minmax<NEx=440.,NEy=99.> {
      in_field => <-.time_field;
   };
   MODS.extract_time_step extract_time_step<NEx=66.,NEy=198.> {
      in_field => <-.set_global_extent.out_fld;
      ExtractStepUI {
         step_typein {
            field {
               x => 0;
            };
            x = 0;
         };
      };
   };
   MODS.extract_time_step extract_time_step#1<NEx=286.,NEy=187.> {
      in_field => <-.set_global_extent.out_fld;
      step = 1;
      ExtractStepUI {
         step_typein {
            field {
               x => 0;
            };
            x = 0;
         };
      };
   };
   MODS.interp_time_step interp_time_step<NEx=528.,NEy=286.> {
      in_field => <-.set_global_minmax.out_fld;
      time => <-.Loop.count;
      InterpStepUI {
         time_typein {
            field {
               x => 0;
            };
            x = 0;
         };
      };
   };
   MODS.external_edges external_edges<NEx=88.,NEy=297.> {
      in_field => <-.extract_time_step.out_fld;
   };
   MODS.external_edges external_edges#1<NEx=297.,NEy=297.> {
      in_field => <-.extract_time_step#1.out_fld;
   };
   MODS.Loop Loop<NEx=572.,NEy=187.> {
      start = 100.;
      end = 200.;
      incr = 10.;
      count = 200.;
      done = 1;
      UIpanel {
         option {
            set = 1;
         };
      };
      LoopUI {
         start_typein {
            x = 0;
         };
         end_typein {
            x = 0;
         };
         incr_typein {
            x = 0;
         };
         count_typein {
            x = 0;
         };
      };
   };
};
