/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/txt_glyp.v#1 $
*/

APPS.SingleWindowApp TextGlyph<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "This example shows how to use the text_glyph macro. This is useful if you want to create an annotation at each node within a field. Note the use for the v syntax: => str_format(\"%3.2f\",<-.extract_data_array.data) to set the format of the annotation.";
      helpfile = "examples/examples_help.htm";
   };

MODS.Read_UCD Read_UCD<NEx=330,NEy=99> {
   read_ucd_ui {
      file_browser {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
         copy_on_change {
            output = 0;
         };
         ok = 1;
      };
   };
};
MODS.external_edges external_edges<NEx=363,NEy=242> {
   in_field => <-.Read_UCD.field;
};
MODS.slice_plane slice_plane<NEx=187,NEy=154> {
   in_field => <-.Read_UCD.field;
   plane {
      xform {
         xlate = {0.236337,0.297759,1.4812};
         mat = {
            0.90401,0.0864082,-0.418686,0.,
	    -0.0150978,0.985202,0.170727,0.,
            0.427243,-0.148018,0.891938,0.,
	    0.,0.,0.,1.
         };
      };
   };
};
GDM.Uviewer3D Uviewer3D<NEx=297.,NEy=385.> {
   Scene {
      Top {
         child_objs => {
            external_edges.out_obj,slice_plane.out_obj_slice,
            text_glyph.out_obj
         };
         Xform {
            mat = {
               0.879099,0.209701,-0.42803,0.,
               -0.104162,0.960834,0.256802,0.,
               0.465118,-0.18117,0.866512,0.,
               0.,0.,0.,1.
            };
            xlate = {-1.77924,-2.18287,0.};
         };
      };
      Lights {
         !Lights[0] {
            type = 3;
         };
      };
   };
};
FLD_MAP.extract_data_array extract_data_array<NEx=11,NEy=209,NEwidth=319,NEheight=297> {
   in => <-.slice_plane.out_fld;
};
MODS.text_glyph text_glyph<NEx=110,NEy=319> {
   in_mesh => <-.slice_plane.out_fld;
   in_text<NEx=154.,NEy=55.,NEwidth=396.,NEheight=187.> => str_format("%3.2f",<-.extract_data_array.data);
   TextUI {
      UImod_panel<NEwidth=198,NEheight=319> {
         title<NEdisplayMode="open">;
      };
   };
   obj {
      Props {
         jitter = 1;
         inherit = 0;
      };
   };
};

};
