/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/txt_mesh.v#1 $
*/

APPS.MultiWindowApp Texture_Mesh<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "Texture_Mesh demonstrates the use of the texture_mesh macro. The Read_Image macro is used to read in the mandrill.x image which is testure mapped over a surf_plot created with an orthoslice of the hydrogen.fld dataset. The beneift of using the texture_mesh macro is that you ge tthe uv coordinates to map the texture automatically generated for you.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Image Read_Image<NEx=363,NEy=88> {
      read_image_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/image/mandrill.x";
         };
      };
   };
   MODS.Read_Field Read_Field<NEx=132,NEy=66> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.orthoslice orthoslice<NEx=33,NEy=121> {
      in_field => <-.Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   MODS.texture_mesh texture_mesh<NEx=187,NEy=264> {
      in_field => <-.surf_plot.out_fld;
      texture => <-.Read_Image.field;
      obj {
         Obj {
            use_altobj = 1;
         };
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=286,NEy=330> {
      Scene {
         Top {
            child_objs => {
               texture_mesh.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0920111,-0.0168783,0.0379205,0.,0.0130362,0.0993025,0.0125681,
0.,-0.0394069,-0.00655905,0.0926982,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-6.5873};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
   MODS.surf_plot surf_plot<NEx=22,NEy=209> {
      in_field => <-.orthoslice.out_fld;
      SurfPlotParam {
         scale = 0.2;
      };
   };
   MODS.bounds bounds<NEx=231,NEy=143> {
      in_field => <-.Read_Field.field;
   };
};
