/*
        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/txt_sphr.v#1 $
*/

APPS.MultiWindowApp Texture_Sphere<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=230.,NEy=20.> {
      demo_text = "This example uses the texture_sphere macro to texture map the avs_old.x image around a sphere. This is commonly used for projecting a map onto a world sphere representation. ";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Image Read_Image<NEx=55.,NEy=55.> {
      read_image_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/image/avs_old.x";
         };
      };
   };
   MODS.texture_sphere texture_sphere<NEx=88.,NEy=143.> {
      texture => <-.Read_Image.field;
   };
   GEOMS.BackgroundFade BackgroundFade<NEx=396.,NEy=99.>;

   GDM.Uviewer3D Uviewer3D<NEx=300,NEy=200> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.texture_sphere.out_obj,
               <-.<-.<-.BackgroundFade.out_obj};
            Xform {
               mat = {
                  -3.62353e-08,4.33745e-07,-4.55594e-07,0.,-5.28789e-07,-2.68173e-07,
-2.13256e-07,0.,-3.40708e-07,3.70084e-07,3.79433e-07,0.,0.,0.,0.,1.
               };
               xlate = {-0.0186718,0.,0.};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 400;
                        defaultY = 300;
                     };
                  };
               };
            };
         };
      };
   };
};
