/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/vol_rend2.v#1 $
*/

// This demo shows the surface finding abilities of the
// Raycast Volume Renderer.  Fat ray is turned off to show
// high-quality results - at the cost of increased computational time.

APPS.SingleWindowApp VolumeRendHiQual<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the use of the volume_render macro, showing the surface finding abilities of the raycast volume renderer. Note that the Fat Ray toggle is switched off so the resulting image is of high quality, but takes a longer time to render.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Readers.Read_Field Read_Field {
      read_field_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/field/hydrogen.fld";
         };
      };
   };
   MODS.Mappers.volume_render volume_render {
      in_mesh => <-.Read_Field.field;
      DataObject {
         Obj {
            use_altobj = 0;
         };
         Props {
            fat_ray = 0;
            inherit = 0;
         };
      };
   };
   MODS.Mappers.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   MODS.Mappers.orthoslice orthoslice {
      in_field => <-.Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {volume_render.out_obj,
                           orthoslice.out_obj,
                           bounds.out_obj};
            Xform {
               ocenter = {31.5,31.5,31.5};
               mat = {
                  0.0997867,0.0237314,0.0748626,0.,0.0176532,0.111172,-0.0587722,
0.,-0.0765242,0.0565917,0.084062,0.,0.,0.,0.,1.
               };
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
         View {
            View {
               renderer = "Software";  // Force SW renderer
            };
         };
      };
   };
};
