/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/vol_roi.v#1 $
*/

APPS.MultiWindowApp TileVolumeROI<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

  UIsummaryPanel Summary_Panel {
      demo_text = "This example shows how to create a ROI with ContinuousSketch and then replicate it across a volume to be displayed with tile_volume_ROIs. Hold down the RMB in the Scene view and draw a freeform polygon. Then select Modules->copyROI and click Run to copy the ROI's across the volume. The Scene#1 viewer will then update with the appropriate ROI's.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Readers.Read_Field Read_Field<NEx=385,NEy=77> {
      read_field_ui {
         file_browser<NEx=11,NEy=143> {
            filename = "$XP_PATH<0>/data/field/hydrogen.fld";
         };
      };
   };
   MODS.Mappers.orthoslice orthoslice<NEx=209,NEy=176> {
      in_field => <-.Read_Field.field;
   };
   MODS.Filters.reset_xform reset_xform<NEx=209,NEy=231> {
      in_field => <-.orthoslice.out_fld;
   };
   GDM.Interactivity.ContinuousSketch ContinuousSketch<NEx=187,NEy=363> {
      view_in => Uviewer2D.Scene_Selector.curr_view;
      obj_in => reset_xform.out_obj;
      cont_sketch {
         GDroi2d_cont<NEx=319,NEy=495> {
            option = 4;
            immed = 1;
         };
      };
   };
   MODS.Mappers.copy_ROI copy_ROI<NEx=451,NEy=242> {
      FieldIn => <-.Read_Field.field;
      MeshIn => <-.ContinuousSketch.cont_sketch.GDmap2d_ss.out_mesh;
      MeshOut<NEx=11,NEy=495> {
         width = 4;
         height = 3;
      };
      Mesh_Array<NEx=11,NEy=451>;
      loop {
         count = 64;
      };
   };
   MODS.Mappers.tile_volume_ROIs tile_volume_ROIs<NEx=594,NEy=330> {
      FieldIn => <-.Read_Field.field;
      Mesh_Array => <-.copy_ROI.DVswitch.out;
   };

   GDM.Uviewer2D Uviewer2D<NEx=462.,NEy=451.> {
      Scene {
         Top {
            child_objs => {reset_xform.out_obj,ContinuousSketch.cont_sketch.DataObject.obj};
         };
      };
      GDM.Uscene2D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {tile_volume_ROIs.GroupObject.obj};
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View,
            <-.Scene#1.View.View};
      };
   };
};
