/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/fld.v#1 $
*/
flibrary+global+sort FLD <
   build_dir="fld",
   build_cmd="$(MAKE)",
   out_hdr_file="Xfld.h",
   out_src_file="Xfld",
   libdeps="GDIF FLDF",
   pre_init_code="   FLDfunc_init();",
   c_hdr_files="avs/fld.h",
#ifndef NO_DL_LOAD
   in_dll=1,
#endif
   link_files="-lfld"
> {
/* 
 * Need to declare the base types implemented by the fld package
 */
$declare_type Tget_coords_unif farray_func
$declare_type Tget_coords_rect farray_func
$declare_type Tget_coords_cyl_unif farray_func
$declare_type Tget_coords_cyl_rect farray_func
$declare_type Tget_coords_spher_unif farray_func
$declare_type Tget_coords_spher_rect farray_func
$declare_type Tget_connect_struct larray_func
$declare_type Tget_connect_polytri val_func
$declare_type Tget_ncells_polytri val_func
$declare_type Tget_connect_polyline val_func
$declare_type Tget_ncells_polyline val_func
$declare_type Tget_connect_polyhedron val_func
$declare_type Tget_ncells_polyhedron val_func

/*--------------------------------------------------*/
/*  Functions that calculate coordinates            */
/*  and connectivity arrays for structured Fields   */
/*  when accessing those arrays as a general Field  */
/*--------------------------------------------------*/

library Internal {

Tget_coords_unif get_coords_unif {/* calculates coordinates for uniform Field */
   int *my_ndim;
   long *my_dims[my_ndim];
   int *my_nspace;
   float *my_points[2][my_nspace];
};

Tget_coords_rect get_coords_rect {/* calculates coords for rectilinear Field */
   int *my_ndim;
   long *my_dims[my_ndim];
   int *my_nspace;
   float *my_points[sum(my_dims)][my_nspace];
};

Tget_coords_cyl_unif get_coords_cyl_unif {/* calculates coordinates for cylindrical uniform Field */
   int *my_ndim;
   long *my_dims[my_ndim];
   int *my_nspace;
   float *my_points[2][my_nspace];
};

Tget_coords_cyl_rect get_coords_cyl_rect {/* calculates coords for cylindrical rectilinear Field */
   int *my_ndim;
   long *my_dims[my_ndim];
   int *my_nspace;
   float *my_points[sum(my_dims)][my_nspace];
};

Tget_coords_spher_unif get_coords_spher_unif {/* calculates coordinates for spherical uniform Field */
   int *my_ndim;
   long *my_dims[my_ndim];
   int *my_nspace;
   float *my_points[2][my_nspace];
};

Tget_coords_spher_rect get_coords_spher_rect {/* calculates coords for spherical rectilinear Field */
   int *my_ndim;
   long *my_dims[my_ndim];
   int *my_nspace;
   float *my_points[sum(my_dims)][my_nspace];
};

/* calculates connectivity for structured fields */
Tget_connect_struct get_connect_struct {
   int *my_ndim;
   long *my_dims[my_ndim];
};

Tget_connect_polytri get_connect_polytri;
Tget_ncells_polytri get_ncells_polytri;
Tget_connect_polyline get_connect_polyline;
Tget_ncells_polyline get_ncells_polyline;
Tget_connect_polyhedron get_connect_polyhedron;
Tget_ncells_polyhedron get_ncells_polyhedron;

};

library Field_Types<export_cxx=1,cxx_name="FLD"> {

/*--------------------------------------------------*/
/*   General Field subelements			    */
/*--------------------------------------------------*/

group Header {
	/*
        string name;
	*/
};

/* 64-bit porting. Only Modified Internally */
group Data_Array {           /* general representation of data array */
	long     nvals;        /* number of elements */
	int 	veclen;       /* vector length of each element */
	int 	id;           /* normals, temperature, pressure, coordinates, color*/
   	prim 	values[nvals][veclen]; /* array itself */
	int+opt     null_flag = 0;      /* indicates presence of NULL data */
	prim+opt    null_value;   	/* value assumed to be NULL data */
	prim 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
	prim 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
	prim    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
	prim    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	string+nonotify 	labels;       /* ascii strings for the labels */
	string+nonotify 	units;        /* ascii strings for the labels */
};

/* 64-bit porting. Only Modified Internally */
group Data_Array_Simple {           /* general representation of data array */
	long     nvals;        /* number of elements */
	int 	veclen;       /* vector length of each element */
	int 	id;           /* normals, temperature, pressure, coordinates, color*/
   	prim 	values[nvals][veclen]; /* array itself */
	int+opt     null_flag = 0;      /* indicates presence of NULL data */
	prim+opt    null_value;   	/* value assumed to be NULL data */
	string+nonotify 	labels;       /* ascii strings for the labels */
	string+nonotify 	units;        /* ascii strings for the labels */
};

group Xform {
	DefaultXform+opt  xform;
};

/* 64-bit porting. Only Modified Internally */
group Grid<NEnumColors=4,NEcolor0=0xff> {		      /* grid description */
	long 	nnodes;	      /* number of nodes */
	int    	nspace;	      /* coordinates dimension */
	Data_Array   coordinates {	/* node coordinates (see Data_Array) */
		nvals => nnodes;
                veclen => nspace;
		float 	values[nvals][veclen];
		float 	min => cache(min_array(magnitude(values), 0, 0));
		float 	max => cache(max_array(magnitude(values), 0, 0));
		float    min_vec[veclen] => cache(min_array(values, 0, 0));
		float    max_vec[veclen] => cache(max_array(values, 0, 0));
	};
};

/* 64-bit porting. Only Modified Internally */
group Cell_Set {		/* cell set description */
	long 	ncells;		/* number of cells      */
	int     cell_ndim;	/* cell dimensionality   */
	int 	cell_nnodes;    /* number of nodes per cell	*/
	int 	cell_corner_nnodes => cell_nnodes;   /* number of corner nodes per cell	*/
	int 	cell_order;     /* cells' order		*/
	int     poly_flag;      /* flag used for polylines, polytriangles */
	long 	node_connect_list[ncells*cell_nnodes];  /* node connectivity array */
	string+opt  name;
	int+opt     nprops;
	float+opt   props[nprops];

	int+opt  poly_type;
	long+opt  npolys;
	int+opt  poly_nnodes[npolys];         /* number of verticies */
	long+opt  poly_connect_list[];
	int+opt  concave_flag;
};

group Cells {			/* contains different cell sets */
	int   ncell_sets;	/* number of cell sets		*/
	Cell_Set  cell_set[ncell_sets];  /* array of cell sets  */
};

/* 64-bit porting. Only Modified Internally */
group Node_Data {			/* data at nodes */
	long nnodes;			/* number of nodes  */
	int	nnode_data;		/* number of data components */
	Data_Array  node_data[nnode_data] {	/* data component descriptions */
		nvals => nnodes;
	};
};

/* 64-bit porting. Only Modified Internally */
group Cell_Data {			/* data at cells  */
	int   ncell_sets;		/* number of different cell sets */
	group  cell_set[ncell_sets] {   /* cell set descriptions */
		long ncells;		/* number of cells 	*/
		int	ncell_data;     /* number of cell data components */
		Data_Array  cell_data[ncell_data] { /* data component descriptions */
			nvals => ncells;
		};
	};
};

group Cell_Data_Poly {			/* data at cells  */
	int   ncell_sets;		/* number of different cell sets */
	group  cell_set[ncell_sets] {   /* cell set descriptions */
		long npolys;		/* number of cells 	*/
		int	ncell_data;     /* number of cell data components */
		Data_Array  cell_data[ncell_data] { /* data component descriptions */
			nvals => npolys;
		};
	};
};

/* 64-bit porting. Only Modified Internally */
group Cell_Data_Set {
	long ncells;
	int	ncell_data; 		    /* number of cell data components */
	Data_Array  cell_data[ncell_data] { /* data component descriptions */
		nvals => ncells;
	};
};

group Cell_Data_Set_Poly {
	long npolys;
	int	ncell_data; 		    /* number of cell data components */
	Data_Array  cell_data[ncell_data] { /* data component descriptions */
		nvals => npolys;
	};
};


Grid+Cells+Xform         Mesh;	/* Mesh consists of grid and cells */

Node_Data+Cell_Data Data;	/* Field data consists of node data and cell data */

/* Field consists of name, mesh and data */
Header+Mesh+Data    Field;

group Hier_Field {			/* Hierarchical field   */
	int 	nchild;			/* number of sub-fields */
	Field   child_field[nchild];	/* sub-fields		*/
};

/*--------------------------------*/
/*      FIELD SUBCLASSES          */
/*--------------------------------*/

Grid Grid_Struct {		/* structured grid      */
	int     ndim;		/* number of dimensions */
	long    dims[ndim];	/* dimensions		*/
	nnodes => prod(dims);	/* number of nodes	*/
	long  	npoints;		/* number of points, defining grid */
	float   points[npoints][nspace]; /* points (extends) defining grid */
	int     grid_type;
};

Node_Data Node_Data_Struct {	/* structured data	*/
	int     ndim;		/* number of dimensions */
	long    dims[ndim];	/* dimensions		*/
	nnodes => prod(dims); 	/* number of nodes	*/
};

Grid_Struct Grid_Unif {		/* uniform grid 	*/
	grid_type = 1;
	npoints = 2;
	coordinates.values => get_coords_unif(ndim, dims, nspace,points);
	coordinates.min => cache(min_array(magnitude(points), 0, 0));
	coordinates.max => cache(max_array(magnitude(points), 0, 0));
	coordinates.min_vec[veclen] => cache(min_array(points, 0, 0));
	coordinates.max_vec[veclen] => cache(max_array(points, 0, 0));
};

Grid_Struct Grid_Rect {		/* rectilinear grid	*/
	grid_type = 2;
	npoints => sum(dims);
	coordinates.values => get_coords_rect(ndim, dims, nspace,points);
	coordinates.min => cache(min_array(magnitude(points), 0, 0));
	coordinates.max => cache(max_array(magnitude(points), 0, 0));
	coordinates.min_vec[veclen] => cache(min_array(points, 0, 0));
	coordinates.max_vec[veclen] => cache(max_array(points, 0, 0));
};

Grid_Struct Grid_Cyl_Unif {		/* uniform grid 	*/
	npoints = 2;
	coordinates.values => get_coords_cyl_unif(ndim, dims, nspace,points);
	coordinates {
		min => cache(min_array(magnitude(values), 0, 0));
		max => cache(max_array(magnitude(values), 0, 0));
		min_vec[veclen] => cache(min_array(values, 0, 0));
	        max_vec[veclen] => cache(max_array(values, 0, 0));
	};
};

Grid_Struct Grid_Cyl_Rect {		/* rectilinear grid	*/
	npoints => sum(dims);
	coordinates.values => get_coords_cyl_rect(ndim, dims, nspace,points);
	coordinates {
		min => cache(min_array(magnitude(values), 0, 0));
		max => cache(max_array(magnitude(values), 0, 0));
		min_vec[veclen] => cache(min_array(values, 0, 0));
	        max_vec[veclen] => cache(max_array(values, 0, 0));
	};
};

Grid_Struct Grid_Spher_Unif {		/* uniform grid 	*/
	npoints = 2;
	coordinates.values => get_coords_spher_unif(ndim, dims, nspace,points);
	coordinates {
		min => cache(min_array(magnitude(values), 0, 0));
		max => cache(max_array(magnitude(values), 0, 0));
		min_vec[veclen] => cache(min_array(values, 0, 0));
	        max_vec[veclen] => cache(max_array(values, 0, 0));
	};
};

Grid_Struct Grid_Spher_Rect {		/* rectilinear grid	*/
	npoints => sum(dims);
	coordinates.values => get_coords_spher_rect(ndim, dims, nspace,points);
	coordinates {
		min => cache(min_array(magnitude(values), 0, 0));
		max => cache(max_array(magnitude(values), 0, 0));
		min_vec[veclen] => cache(min_array(values, 0, 0));
	        max_vec[veclen] => cache(max_array(values, 0, 0));
	};
};

Cell_Set Cell_Set_Struct  {	/* definition of cell set for structured mesh */
	long cell_dims[cell_ndim];	/* cell dimensionality	*/
	ncells => prod(cell_dims-1);	/* number of cells	*/
	cell_nnodes => pow (2.0,cell_ndim);/* number of nodes per cell	*/
	cell_corner_nnodes => cell_nnodes;
	cell_order = 1;			/* cell's order			*/
	poly_flag = 0;
        node_connect_list => get_connect_struct(cell_ndim, cell_dims); /* cell connectivty */
};

Cells Cells_Struct {		/* cells definition for structured mesh */
	int     ndim;
    long    dims[ndim];
	ncell_sets = 1;
	Cell_Set_Struct cell_set {
   	    cell_ndim => ndim;
	    cell_dims => dims;
	};
};

/* 64-bit porting. Only Modified Internally */
Cell_Data Cell_Data_Struct {	/* cell data definition for structured field */
	int     ndim;
    long    dims[ndim];
	int     ncell_sets = 1;
	group  cell_set {
           long  ncells => prod(dims-1);
           int  ncell_data;
           Data_Array  cell_data[ncell_data] {
                   nvals => ncells;
           };
        };

};

Node_Data_Struct+Cell_Data_Struct  Data_Struct;	/* structured data includes node and cell data 	*/

Grid_Struct+Cells_Struct+Xform     Mesh_Struct; 	/* structured mesh consists of grid and cells	*/

Grid_Unif+Cells_Struct+Xform       Mesh_Unif;	/* uniform mesh 	*/

Grid_Rect+Cells_Struct+Xform       Mesh_Rect;	/* rectilinear mesh 	*/

Grid_Cyl_Unif+Cells_Struct+Xform   Mesh_Cyl_Unif;	/* uniform mesh 	*/

Grid_Cyl_Rect+Cells_Struct+Xform   Mesh_Cyl_Rect;	/* rectilinear mesh 	*/

Grid_Spher_Unif+Cells_Struct+Xform Mesh_Spher_Unif;	/* uniform mesh 	*/

Grid_Spher_Rect+Cells_Struct+Xform Mesh_Spher_Rect;	/* rectilinear mesh 	*/

Header+Mesh_Struct+Data_Struct    Field_Struct;	/* structured field consists of mesh and data	*/

Header+Mesh_Unif+Data_Struct    Field_Unif;	/* uniform field	*/

Header+Mesh_Rect+Data_Struct    Field_Rect;	/* rectilinear field	*/

Header+Mesh_Cyl_Unif+Data_Struct    Field_Cyl_Unif;	/* uniform field	*/

Header+Mesh_Cyl_Rect+Data_Struct    Field_Cyl_Rect;	/* rectilinear field	*/

Header+Mesh_Spher_Unif+Data_Struct    Field_Spher_Unif;	/* uniform field	*/

Header+Mesh_Spher_Rect+Data_Struct    Field_Spher_Rect;	/* rectilinear field	*/

/*--------------------*/
/*      CELLS         */
/*--------------------*/

Cell_Set Point<indexed=0> {		/* point cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 1;
	cell_ndim = 0;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 1;
	string+virtual cell_name = "Point";
	float+virtual node_uvw[1][3] = {{0.0,0.0,0.0}};
};

Cell_Set Line<indexed=0> {			/* line cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 2;
	cell_ndim = 1;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 2;
	string+virtual cell_name = "Line";
	float+virtual node_uvw[2][3] = {{-1.0,0.0,0.0}, {1.0,0.0,0.0}};
};

Cell_Set Line2<indexed=0> {			/* line cell definition	*/
	cell_corner_nnodes=>;
	cell_nnodes = 3;
	cell_corner_nnodes = 2;    /* number of corner nodes per cell	*/
	cell_ndim = 1;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 12;
	string+virtual cell_name = "Line2";
	float+virtual node_uvw[3][3] = {{-1.0,0.0,0.0}, {1.0,0.0,0.0}, {0.0,0.0,0.0}};
};

Cell_Set Polyline<cxx_name="PolyLine",indexed=0> {/* polyline cell definition */
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 2;
	cell_ndim = 1;
	cell_order = 1;
	poly_flag = 1;
	poly_nnodes =>cache(init_array(npolys,2,2));
	poly_connect_list[npolys*2];  /* node connectivity array */
	ncells => cache(get_ncells_polyline(npolys, poly_connect_list));
	node_connect_list => cache(get_connect_polyline(npolys, poly_connect_list));
	int+virtual cell_type = 3;
	string+virtual cell_name = "Polyline";
	float+virtual node_uvw[2][3] = {{-1.0,0.0,0.0}, {1.0,0.0,0.0}};
};

Cell_Set Tri<indexed=0> {		/* triangle cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 3;
	cell_ndim = 2;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 4;
	string+virtual cell_name = "Tri";
	float+virtual node_uvw[3][3] = {{1.0,0.0,0.0}, {0.0,1.0,0.0}, {0.0,0.0,0.0}};
};

Cell_Set Tri2<indexed=0> {		/* triangle cell definition	*/
	cell_corner_nnodes=>;
	cell_nnodes = 6;
	cell_corner_nnodes = 3;    /* number of corner nodes per cell	*/
	cell_ndim = 2;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 14;
	string+virtual cell_name = "Tri2";
	float+virtual node_uvw[6][3] = {{1.0,0.0,0.0}, {0.0,1.0,0.0}, {0.0,0.0,0.0},
					{0.5,0.5,0.0}, {0.0,0.5,0.0}, {0.5,0.0,0.0}};
};

Cell_Set Polytri<indexed=0> {		/* triangle cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 3;
	cell_ndim = 2;
	cell_order = 1;
	poly_flag = 1;
	poly_type-opt = 2;   /* to distinguish from Polyhedron */
	poly_nnodes =>cache(init_array(npolys,2,2));
	poly_connect_list[npolys*2];  /* node connectivity array */
	ncells => cache(get_ncells_polytri(npolys, poly_connect_list));
	node_connect_list => cache(get_connect_polytri(npolys, poly_connect_list));
	int+virtual cell_type = 10;
	string+virtual cell_name = "Polytri";
	float+virtual node_uvw[3][3] = {{1.0,0.0,0.0}, {0.0,1.0,0.0}, {0.0,0.0,0.0}};
};

Cell_Set Quad<indexed=0> {		/* quad cell definition		*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 4;
	cell_ndim = 2;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 5;
	string+virtual cell_name = "Quad";
	float+virtual node_uvw[4][3] = {{-1.0,-1.0,0.0}, {1.0,-1.0,0.0}, 
					{1.0,1.0,0.0},   {-1.0,1.0,0.0}};
};

Cell_Set Quad2<indexed=0> {		/* quad cell definition		*/
	cell_corner_nnodes=>;
	cell_nnodes = 8;
	cell_corner_nnodes = 4;    /* number of corner nodes per cell	*/
	cell_ndim = 2;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 15;
	string+virtual cell_name = "Quad2";
	float+virtual node_uvw[8][3] = {{-1.0,-1.0,0.0}, {1.0,-1.0,0.0}, 
					{1.0,1.0,0.0},   {-1.0,1.0,0.0},
					{0.0,-1.0,0.0},  {1.0,0.0,0.0}, 
					{0.0,1.0,0.0},   {-1.0,0.0,0.0}};
};

Cell_Set Tet<indexed=0> {		/* tetra cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 4;
	cell_ndim = 3;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 6;
	string+virtual cell_name = "Tet";
	int+virtual cell_nfaces = 4;				/* number of faces */
	int+virtual cell_face_nnodes[4]={3, 3, 3, 3}; /* nodes per face  */
	int+virtual cell_face_connect[12]= {1, 2, 0,
					    2, 3, 0,
					    3, 1, 0,
					    1, 3, 2};
	int+virtual cell_face_corner_nnodes[4]={3, 3, 3, 3}; /* nodes per face  */
	float+virtual node_uvw[4][3] = {{1.0,0.0,0.0}, {0.0,1.0,0.0}, {0.0,0.0,1.0}, {0.0,0.0,0.0}};
};

Cell_Set Tet2<indexed=0> {	/* tetra second order cell definition	*/
	cell_corner_nnodes=>;
	cell_nnodes = 10;
	cell_corner_nnodes = 4;    /* number of corner nodes per cell	*/
	cell_ndim = 3;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 16;
	string+virtual cell_name = "Tet2";
	int+virtual cell_nfaces = 4;				/* number of faces */
	int+virtual cell_face_nnodes[4]={6, 6, 6, 6}; /* nodes per face  */
	int+virtual cell_face_connect[24]= {1, 2, 0, 7, 5, 4,
					    2, 3, 0, 8, 6, 5,
					    3, 1, 0, 9, 4, 6,
					    1, 3, 2, 9, 8, 7};
	int+virtual cell_face_corner_nnodes[4]={3, 3, 3, 3}; /* nodes per face  */
	float+virtual node_uvw[10][3] = {{1.0,0.0,0.0}, {0.0,1.0,0.0}, {0.0,0.0,1.0}, {0.0,0.0,0.0},
					 {0.5,0.5,0.0}, {0.5,0.0,0.5}, {0.5,0.0,0.0}, {0.0,0.5,0.5},
					 {0.0,0.0,0.5}, {0.0,0.5,0.0}};
};
Cell_Set Hex<indexed=0> {		/* hex cell definition		*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 8;
	cell_ndim = 3;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 7;
	string+virtual cell_name = "Hex";
	int+virtual cell_nfaces = 6;
	int+virtual cell_face_nnodes[6]={4, 4, 4, 4, 4, 4};
	int+virtual cell_face_connect[24]= {0, 1, 2, 3,
					    1, 5, 6, 2,
					    3, 2, 6, 7,
					    0, 3, 7, 4,
					    0, 4, 5, 1,
					    4, 7, 6, 5 };
	int+virtual cell_face_corner_nnodes[6]={4, 4, 4, 4, 4, 4};
	float+virtual node_uvw[8][3] = {{-1.0,1.0,1.0}, {-1.0,-1.0,1.0}, {1.0,-1.0,1.0}, {1.0,1.0,1.0},
					 {-1.0,1.0,-1.0},{-1.0,-1.0,-1.0},{1.0,-1.0,-1.0},{1.0,1.0,-1.0}};
};

Cell_Set Hex2<indexed=0> {		/* hex cell definition		*/
	cell_corner_nnodes=>;
	cell_nnodes = 20;
	cell_corner_nnodes = 8;    /* number of corner nodes per cell	*/
	cell_ndim = 3;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 17;
	string+virtual cell_name = "Hex2";
	int+virtual cell_nfaces = 6;
	int+virtual cell_face_nnodes[6]={8, 8, 8, 8, 8, 8};
	int+virtual cell_face_connect[48]= {0, 1, 2, 3, 8,9,10,11,
					    1, 5, 6, 2, 17,13,18,9,
					    3, 2, 6, 7, 10,18,14,19,
					    0, 3, 7, 4, 11,19,15,16,
					    0, 4, 5, 1, 16,12,17,8,
					    4, 7, 6, 5, 15,14,13,12};
	int+virtual cell_face_corner_nnodes[6]={4, 4, 4, 4, 4, 4};
	float+virtual node_uvw[20][3] = {{-1.0,1.0,1.0}, {-1.0,-1.0,1.0}, {1.0,-1.0,1.0}, {1.0,1.0,1.0},
					 {-1.0,1.0,-1.0},{-1.0,-1.0,-1.0},{1.0,-1.0,-1.0},{1.0,1.0,-1.0},
					 {-1.0,0.0,1.0}, {0.0,-1.0,1.0}, {1.0,0.0,1.0}, {0.0,1.0,1.0},
					 {-1.0,0.0,-1.0},{0.0,-1.0,-1.0},{1.0,0.0,-1.0},{0.0,1.0,-1.0},
					 {-1.0,1.0,0.0}, {-1.0,-1.0,0.0},{1.0,-1.0,0.0},{1.0,1.0,0.0}};
};

Cell_Set Pyr<indexed=0> {		/* pyramid cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 5;
	cell_ndim = 3;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 9;
	string+virtual cell_name = "Pyr";
	int+virtual cell_nfaces = 5;
	int+virtual cell_face_nnodes[5]={3, 3, 3, 3, 4};
	int+virtual cell_face_connect[16]= {0, 1, 2,
					    0, 2, 3,
					    0, 3, 4,
					    4, 1, 0,
					    1, 4, 3, 2};
	int+virtual cell_face_corner_nnodes[5]={3, 3, 3, 3, 4};
	float+virtual node_uvw[5][3] = {{0.0,0.0,1.0},{1.0,1.0,-1.0},{-1.0,1.0,-1.0}, {-1.0,-1.0,-1.0},
					 {1.0,-1.0,-1.0}};
};

Cell_Set Pyr2<indexed=0> {		/* pyramid cell definition	*/
	cell_corner_nnodes=>;
	cell_nnodes = 13;
	cell_corner_nnodes = 5;    /* number of corner nodes per cell	*/
	cell_ndim = 3;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 19;
	string+virtual cell_name = "Pyr2";
	int+virtual cell_nfaces = 5;
	int+virtual cell_face_nnodes[5]={6, 6, 6, 6, 8};
	int+virtual cell_face_connect[32]= {0, 1, 2, 5,9,6,
					    0, 2, 3, 6,10,7,
					    0, 3, 4, 7,11,8,
					    4, 1, 0, 12,5,8,
					    1, 4, 3, 2, 12,11,10,9};
	int+virtual cell_face_corner_nnodes[5]={3, 3, 3, 3, 4};
	float+virtual node_uvw[13][3] = {{0.0,0.0,1.0},{1.0,1.0,-1.0},{-1.0,1.0,-1.0}, {-1.0,-1.0,-1.0},
					 {1.0,-1.0,-1.0},
					 {0.0,1.0,1.0},{0.0,-1.0,1.0},{0.0,-1.0,-1.0}, {0.0,1.0,-1.0},
					 {1.0,0.0,1.0},{1.0,-1.0,0.0},{1.0,0.0,-1.0},{1.0,1.0,0.0}};
};

Cell_Set Prism<indexed=0> {		/* prism cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 6;
	cell_ndim = 3;
	cell_order = 1;
	poly_flag = 0;
	int+virtual cell_type = 8;
	string+virtual cell_name = "Prism";
	int+virtual cell_nfaces = 5;
	int+virtual cell_face_nnodes[5]={3, 3, 4, 4, 4};
	int+virtual cell_face_connect[18]= {5, 4, 3,
					    0, 1, 2,
					    1, 4, 5, 2,
					    1, 0, 3, 4,
					    0, 2, 5, 3 };
	int+virtual cell_face_corner_nnodes[5]={3, 3, 4, 4, 4};
	float+virtual node_uvw[6][3] = {{1.0,0.0,1.0}, {0.0,1.0,1.0}, {0.0,0.0,1.0}, 
					{1.0,0.0,-1.0},{0.0,1.0,-1.0}, {0.0,0.0,-1.0}};
};

Cell_Set Prism2<indexed=0> {		/* prism cell definition	*/
	cell_corner_nnodes=>;
	cell_nnodes = 15;
	cell_corner_nnodes = 6;    /* number of corner nodes per cell	*/
	cell_ndim = 3;
	cell_order = 2;
	poly_flag = 0;
	int+virtual cell_type = 18;
	string+virtual cell_name = "Prism2";
	int+virtual cell_nfaces = 5;
	int+virtual cell_face_nnodes[5]={6, 6, 8, 8, 8};
	int+virtual cell_face_connect[36]= {5, 4, 3, 10,9,11,
					    0, 1, 2, 6,7,8,
					    1, 4, 5, 2, 13,10,14,7,
					    1, 0, 3, 4, 6,12,9,13,
					    0, 2, 5, 3, 8,14,11,12};
	int+virtual cell_face_corner_nnodes[5]={3, 3, 4, 4, 4};
	float+virtual node_uvw[15][3] = {{1.0,0.0,1.0}, {0.0,1.0,1.0}, {0.0,0.0,1.0}, 
					 {1.0,0.0,-1.0},{0.0,1.0,-1.0}, {0.0,0.0,-1.0},
					 {0.5,0.5,1.0}, {0.0,0.5,1.0}, {0.5,0.0,1.0}, 
					 {0.5,0.5,-1.0},{0.0,0.5,-1.0},{0.5,0.0,-1.0},
					 {0.0,1.0,0.0},{1.0,0.0,0.0}, {0.0,0.0,0.0}};
};

Cell_Set Polyhedron<indexed=0> {	/* polyhedron cell definition	*/
	cell_corner_nnodes => cell_nnodes;
	cell_nnodes = 3;
	cell_ndim = 2;
	cell_order = 1;
	poly_flag = 1;
	poly_type-opt = 1;   /* to distinguish from Polytri */
	ncells => cache(get_ncells_polyhedron(npolys, poly_nnodes));
	node_connect_list => cache(get_connect_polyhedron(npolys, poly_nnodes,
				              poly_connect_list, concave_flag));
	int+virtual cell_type = 19;
	string+virtual cell_name = "Polyhedron";
	float+virtual node_uvw[3][3] => {{1.0,0.0,0.0}, {0.0,1.0,0.0}, {0.0,0.0,0.0}};
};


/* Multi Block Field */

group Multi_Block {
	int nblocks;
	Mesh_Struct+Node_Data+Port2 fields[nblocks];
	group coordinates {
		int+nres      veclen =>  cache(max_array(fields.nspace, 0, 0));
		float+nres    min_vec[veclen] => cache(min_array(fields.coordinates.min_vec, 0, 0));
		float+nres    max_vec[veclen] => cache(max_array(fields.coordinates.max_vec, 0, 0));
	};
};

};

//
// This is marked without the user_library so that we don't end up
// having to generate C++ classes for these objects.  We could also
// do this with the "export" property
//
library Macros<user_library=0> {
/*----------------------*/
/*   FIELD SUBTYPES	*/
/*----------------------*/

group Space3 {		/* 3-space grid */
	int nspace = 3;
};

group Space2 {		/* 2-space grid */
      int nspace = 2;
};

group Space1 {		/* 1-space grid */
      int nspace = 1;
};

group Scalar {		/* scalar data */
	int nnode_data = 1;
	group node_data {
			int  veclen = 1;
	};
};

group Vector {		/* 3-vector data */
	int nnode_data = 1;
	group node_data {
			int  veclen = 3;
	};
};

group Vector2 {		/* 2-vector data */
	int nnode_data = 1;
	group node_data {
			int  veclen = 2;
	};
};

group Vector3 {		/* 3-vector data */
	int nnode_data = 1;
	group node_data {
			int  veclen = 3;
	};
};

group Vector4 {		/* 4-vector data */
	int nnode_data = 1;
	group node_data {
			int  veclen = 4;
	};
};

group Cell_Scalar {		/* scalar data */
	int ncell_data = 1;
	group cell_data {
			int  veclen = 1;
	};
};

group Cell_Vector2 {		/* 2-vector data */
	int ncell_data = 1;
	group cell_data {
			int  veclen = 2;
	};
};

group Cell_Vector3 {		/* 3-vector data */
	int ncell_data = 1;
	group cell_data {
			int  veclen = 3;
	};
};

group Cell_Vector4 {		/* 4-vector data */
	int ncell_data = 1;
	group cell_data {
			int  veclen = 4;
	};
};

group Dim0<NEcolor1=0xffff00> {/* 0-dimensions structured field */
	int ndim = 0;
};

group Dim1<NEcolor1=0xff> { /* 1-dimensions structured field */
	int ndim = 1;
};

group Dim2<NEcolor1=0xff00> {/* 2-dimensions structured field */
	int ndim = 2;
};

group Dim3<NEcolor1=0xff0000> {	/* 3-dimensions structured field */
	int ndim = 3;
};

group Byte<NEcolor2=0xffff00> {	/* byte data array     	*/
	Data_Array  node_data {
		byte 	values[nvals][veclen]; /* array itself */
		byte+opt    null_value;   	/* value assumed to be NULL data */
		byte 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		byte 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		byte    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		byte    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Int<NEcolor2=0xff> {	/* int data array     	*/
	Data_Array  node_data {
		int 	values[nvals][veclen]; /* array itself */
		int+opt    null_value;   	/* value assumed to be NULL data */
		int 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		int 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		int    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		int    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Long<NEcolor2=0xff> {	/* long data array     	*/
	Data_Array  node_data {
		long 	values[nvals][veclen]; /* array itself */
		long+opt    null_value;   	/* value assumed to be NULL data */
		long 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		long 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		long    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		long    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Short<NEcolor2=0xff> {	/* int data array     	*/
	Data_Array  node_data {
		short 	values[nvals][veclen]; /* array itself */
		short+opt    null_value;   	/* value assumed to be NULL data */
		short 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		short 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		short    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		short    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Float<NEcolor2=0xff00> { /* float data array    	*/
	Data_Array  node_data {
		float 	values[nvals][veclen]; /* array itself */
		float+opt    null_value;   	/* value assumed to be NULL data */
		float 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		float 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		float    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		float    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

Node_Data+Byte		Node_Data_Byte;
Node_Data+Int		Node_Data_Int;
Node_Data+Long		Node_Data_Long;
Node_Data+Short		Node_Data_Short;
Node_Data+Float		Node_Data_Float;

group Cell_Byte<NEcolor2=0xffff00> {	/* byte data array     	*/
	Data_Array  cell_data {
		byte 	values[nvals][veclen]; /* array itself */
		byte+opt    null_value;   	/* value assumed to be NULL data */
		byte 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		byte 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		byte    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		byte    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Cell_Int<NEcolor2=0xff> {	/* int data array     	*/
	Data_Array  cell_data {
		int 	values[nvals][veclen]; /* array itself */
		int+opt    null_value;   	/* value assumed to be NULL data */
		int 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		int 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		int    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		int    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Cell_Long<NEcolor2=0xff> {	/* long data array     	*/
	Data_Array  cell_data {
		long 	values[nvals][veclen]; /* array itself */
		long+opt    null_value;   	/* value assumed to be NULL data */
		long 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		long 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		long    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		long    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Cell_Short<NEcolor2=0xff> {	/* int data array     	*/
	Data_Array  cell_data {
		short 	values[nvals][veclen]; /* array itself */
		short+opt    null_value;   	/* value assumed to be NULL data */
		short 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		short 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		short    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		short    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

group Cell_Float<NEcolor2=0xff00> { /* float data array    	*/
	Data_Array  cell_data {
		float 	values[nvals][veclen]; /* array itself */
		float+opt    null_value;   	/* value assumed to be NULL data */
		float 	min => cache(min_array(magnitude(values), null_flag, null_value));
					/* min value of the data in each array */
		float 	max => cache(max_array(magnitude(values), null_flag, null_value));
					/* max value of the data in each array */
		float    min_vec[veclen] => cache(min_array(values, null_flag, null_value));
					/* min extent of the data in each array */
		float    max_vec[veclen] => cache(max_array(values, null_flag, null_value));
					/* max extent of the data in each array */
	};
};

/* 64-bit porting. Only Modified Internally */
group Node_Data_Opt {			/* optional data at nodes */
	long nnodes;			/* number of nodes  */
	int+opt	nnode_data;		/* number of data components */
	Data_Array+opt  node_data[nnode_data] {	/* data component descriptions */
		nvals => nnodes;
	};
};
/* 64-bit porting. Only Modified Internally */
group Cell_Data_Opt {			/* optional data at cells  */
	int   ncell_sets;		/* number of different cell sets */
	group  cell_set[ncell_sets] {   /* cell set descriptions */
		long 	ncells;		/* number of cells 	*/
		int+opt	ncell_data;     /* number of cell data components */
		Data_Array+opt  cell_data[ncell_data] { /* data component descriptions */
			nvals => ncells;
		};
	};
};


////////////////////////////////
//  Time dependent data
////////////////////////////////
/* 64-bit porting. Only Modified Internally */
group Time_Grid<NEnumColors=4,NEcolor0=0xff> { /* grid description */
	long 	nnodes;	      /* number of nodes */
	int    	nspace;	      /* coordinates dimension */
	int     nsteps;	      /* number of time steps */
	double  time[nsteps]; /* time values */
	group   time_coordinates[nsteps] {	/* node coordinates (see Data_Array) */
		double+nres time => <-.time[index_of(time_coordinates)];	/* time value */
		long nnodes => <-.nnodes;
		int nspace => <-.nspace;
		Data_Array coordinates {
			nvals => <-.nnodes;
                	veclen => <-.nspace;
			float 	values[nvals][veclen];
			float 	min => cache(min_array(magnitude(values), 0, 0));
			float 	max => cache(max_array(magnitude(values), 0, 0));
			float    min_vec[veclen] => cache(min_array(values, 0, 0));
			float    max_vec[veclen] => cache(max_array(values, 0, 0));
		};
	};
};
Time_Grid Time_Grid_Struct {	/* structured grid      */
	int     ndim;		/* number of dimensions */
	long    dims[ndim];	/* dimensions		*/
	nnodes => prod(dims);	/* number of nodes	*/
};

Time_Grid+Cells+Xform         		Time_Mesh;
Time_Grid_Struct+Cells_Struct+Xform     Time_Mesh_Struct;

/* 64-bit porting. Only Modified Internally */
group Time_Node_Data {
	long nnodes;		/* number of nodes  */
	int	nnode_data;	/* number of data components */
	int     nsteps;		/* number of time steps */
	double  time[nsteps]; 	/* time values */
	Node_Data time_node_data[nsteps] {
		double+nres time => <-.time[index_of(time_node_data)];	/* time value */
		nnodes => <-.nnodes;
		nnode_data => <-.nnode_data;
	};
};

/* 64-bit porting. Only Modified Internally */
group Time_Cell_Data_Set {
	long	ncells;
	int	ncell_data; 	/* number of cell data components */
	int     nsteps;		/* number of time steps */
	double  time[nsteps]; 	/* time values */
	Cell_Data_Set time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		ncells => <-.ncells;
		ncell_data => <-.ncell_data;
	};
};

group Time_Cell_Data_Set_Poly {
	long npolys;
	int	ncell_data;   	/* number of cell data components */
	int     nsteps;	      	/* number of time steps */
	double  time[nsteps]; 	/* time values */
	Cell_Data_Set_Poly time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		npolys => <-.npolys;
		ncell_data => <-.ncell_data;
	};
};

group Time_Cell_Data {		/* data at cells  */
	int   ncell_sets;	/* number of different cell sets */
	Cell_Set+Time_Cell_Data_Set  cell_set[ncell_sets] {   /* cell set descriptions */
	};
};

group Time_Cell_Data_Poly {	/* data at cells  */
	int   ncell_sets;	/* number of different cell sets */
	Cell_Set+Time_Cell_Data_Set_Poly  cell_set[ncell_sets] {   /* cell set descriptions */
	};
};


Time_Node_Data Time_Node_Data_Byte {
	Node_Data+Byte time_node_data[nsteps] {
		double+nres time => <-.time[index_of(time_node_data)];	/* time value */
		nnodes => <-.nnodes;
		nnode_data => <-.nnode_data;
	};
};

Time_Node_Data Time_Node_Data_Short {
	Node_Data+Short time_node_data[nsteps] {
		double+nres time => <-.time[index_of(time_node_data)];	/* time value */
		nnodes => <-.nnodes;
		nnode_data => <-.nnode_data;
	};
};

Time_Node_Data Time_Node_Data_Int {
	Node_Data+Int time_node_data[nsteps] {
		double+nres time => <-.time[index_of(time_node_data)];	/* time value */
		nnodes => <-.nnodes;
		nnode_data => <-.nnode_data;
	};
};

Time_Node_Data Time_Node_Data_Long {
	Node_Data+Long time_node_data[nsteps] {
		double+nres time => <-.time[index_of(time_node_data)];	/* time value */
		nnodes => <-.nnodes;
		nnode_data => <-.nnode_data;
	};
};

Time_Node_Data Time_Node_Data_Float {
	Node_Data+Float time_node_data[nsteps] {
		double+nres time => <-.time[index_of(time_node_data)];	/* time value */
		nnodes => <-.nnodes;
		nnode_data => <-.nnode_data;
	};
};


Time_Cell_Data_Set Time_Cell_Data_Set_Byte {
	Cell_Data_Set+Cell_Byte time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		ncells => <-.ncells;
		ncell_data => <-.ncell_data;
	};
};

Time_Cell_Data_Set Time_Cell_Data_Set_Short {
	Cell_Data_Set+Cell_Short time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		ncells => <-.ncells;
		ncell_data => <-.ncell_data;
	};
};

Time_Cell_Data_Set Time_Cell_Data_Set_Int {
	Cell_Data_Set+Cell_Int time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		ncells => <-.ncells;
		ncell_data => <-.ncell_data;
	};
};

Time_Cell_Data_Set Time_Cell_Data_Set_Long {
	Cell_Data_Set+Cell_Long time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		ncells => <-.ncells;
		ncell_data => <-.ncell_data;
	};
};

Time_Cell_Data_Set Time_Cell_Data_Set_Float {
	Cell_Data_Set+Cell_Float time_cell_data[nsteps] {
		double+nres time => <-.time[index_of(time_cell_data)];	/* time value */
		ncells => <-.ncells;
		ncell_data => <-.ncell_data;
	};
};


Time_Cell_Data Time_Cell_Data_Byte {
	Cell_Set+Time_Cell_Data_Set_Byte  cell_set[ncell_sets];
};
Time_Cell_Data Time_Cell_Data_Short {
	Cell_Set+Time_Cell_Data_Set_Short  cell_set[ncell_sets];
};
Time_Cell_Data Time_Cell_Data_Int {
	Cell_Set+Time_Cell_Data_Set_Int  cell_set[ncell_sets];
};
Time_Cell_Data Time_Cell_Data_Long {
	Cell_Set+Time_Cell_Data_Set_Long  cell_set[ncell_sets];
};
Time_Cell_Data Time_Cell_Data_Float {
	Cell_Set+Time_Cell_Data_Set_Float  cell_set[ncell_sets];
};

////////////////////////////////////

/* Mesh Sub-Classes */

Mesh_Unif+Dim2+Space2+Node_Data_Byte+Scalar   Image {
	points => {{0,0}, {dims[0]-1,dims[1]-1}};
};

Mesh_Unif+Dim2+Space2+Node_Data_Byte+Vector3   Image_RGB {
	points => {{0,0}, {dims[0]-1,dims[1]-1}};
	node_data {
		id = 669;
	};
};

Mesh_Unif+Dim2+Space2+Node_Data_Byte+Vector4   Image_ARGB {
	points => {{0,0}, {dims[0]-1,dims[1]-1}};
	node_data {
		id = 669;
	};
};

Mesh_Unif+Dim3+Space3+Node_Data+Scalar   Volume {
	points => {{0,0,0}, {dims[0]-1,dims[1]-1,dims[2]-1}};
};

Mesh+Space2+Node_Data Mesh_Points_2D {
	Point cell_set[] {
		ncells => <-.nnodes;
		node_connect_list => init_array(ncells, 0, ncells-1);
	};
};
Mesh+Space3+Node_Data Mesh_Points_3D {
	Point cell_set[] {
		ncells => <-.nnodes;
		node_connect_list => init_array(ncells, 0, ncells-1);
	};
};
Mesh+Space2+Scalar+Node_Data_Float Mesh_Spheres_2D {
	Point cell_set[] {
		ncells => <-.nnodes;
		node_connect_list => init_array(ncells, 0, ncells-1);
	};
	node_data {
		id = 668;
	};
};
Mesh+Space3+Scalar+Node_Data_Float Mesh_Spheres_3D {
	Point cell_set[] {
		ncells => <-.nnodes;
		node_connect_list => init_array(ncells, 0, ncells-1);
	};
	node_data {
		id = 668;
	};
};

Mesh+Space2+Node_Data Mesh_Lines_2D {
	Line cell_set[];
};
Mesh+Space3+Line+Node_Data Mesh_Lines_3D {
	Line cell_set[];
};
Mesh+Space2+Node_Data Mesh_Tris_2D {
	Tri cell_set[];
};
Mesh+Space3+Node_Data Mesh_Tris_3D {
	Tri cell_set[];
};
Mesh+Space2+Node_Data Mesh_Quads_2D {
	Quad cell_set[];
};
Mesh+Space3+Node_Data Mesh_Quads_3D {
	Quad cell_set[];
};

Grid_Unif+Space1+Dim1   Line_Grid;
Grid_Unif+Space2+Dim2   Plane_Grid;
Grid_Unif+Space3+Dim3   Box_Grid;
Mesh_Unif+Space1+Dim1   Line_Mesh;
Mesh_Unif+Space2+Dim2   Plane_Mesh;
Mesh_Unif+Space3+Dim3   Box_Mesh;
Mesh Point_Mesh {
	nnodes = 1;
	ncell_sets = 1;
	Point cell_set {
		ncells = 1;
		node_connect_list={0};
	};
};


group Block_Table {
	int grid_size=0;
	int nblocks=0;
	int blocks[nblocks];
	int list_size;
	int cell_list[list_size];
	int list_link[list_size];
	int list_incr;
	int loc;
};

/* 64-bit porting. Only Modified Internally */
group NParam_Data {
	long nnodes;
	int min_node[nnodes];
	int max_node[nnodes];
	float tpar[nnodes];
};

/* Definitions for all groups associated with text */

/* Standard text attributes - applies to both annotation and
   stroke style text.
*/
group TextAttribs {
        int align_horiz;                /* enumerated GD_ALIGN_HORIZ_xxx */
        int align_vert;                 /* enumerated GD_ALIGN_VERT_xxx  */
        int drop_shadow;                /* boolean option */
        int background;                 /* boolean option */
        int bounds;                     /* boolean option */
        int underline;                  /* boolean option */
        int lead_line;                  /* boolean option */
        int radial;                     /* boolean option */
        int do_offset;                  /* boolean option */
        float offset[3];
        int xform_mode;			/* boolean option */
};

/* Stroke text attributes - applies to stroke text ONLY. */
group StrokeTextAttribs {
        int font_type;
        int style;
        int plane;
        int orient;
        int path;
        int space_mode;
        float spacing;
        float angle;
        float height;
        float expansion;
        float width;
};

/* Groups for single text string */

TextAttribs Text_NoXform {
	string str;			/* string to render */
	int nspace;
	float position[nspace];		/* vert to render string at */
        int stroke = 0;
        StrokeTextAttribs StrokeTextAttribs;
};

Text_NoXform+Xform Text {
	float+write min_vec[nspace];
	float+write max_vec[nspace];
};

/* Groups for array of text strings */

TextAttribs TextValues {
	int color;			/* boolean option */
        string text_values[];
        int stroke = 0;
        StrokeTextAttribs StrokeTextAttribs;
};

Grid+Xform+TextValues  TextField;

Field+Xform+TextValues LabelField;

/* Groups for tile render methods */

/* user_class=1 is temporary workaround for bug with copying MeshArr */
group Mesh_Array_NoXform<user_class=1> {
	int start;
	int width;
	int height;
	int orientation;
	int mode;
	int border_width;
	Mesh_Struct &MeshIn;
	int nmesh;
	Mesh+Data MeshArr[nmesh];
//	float+opt z_coord[nmesh];
};

Mesh_Array_NoXform+OPort Mesh_Array {
	DefaultXform+opt xform;
	DefaultXform+opt tile_xform;
};

group Tiled_Volume_NoXform {
	int start;
	int width;
	int height;
	int orientation;
	int mode;
	int border_width;
	Mesh_Unif+Node_Data &VolIn;
};

Tiled_Volume_NoXform+OPort Tiled_Volume {
	DefaultXform+opt xform;
	DefaultXform+opt tile_xform;
};

};
};
