//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//	
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/fld_map.v#1 $
//	
flibrary FLD_MAP<needs_use_lic="GD",needs_edit_lic="DV",
	      compile_subs=0> {
library+global+buffered Mesh_Mappers {

group uniform_mesh {
	long+IPort2  in_dims[];
	
	int init0[] => init_array(array_size(in_dims),0,0);

	Mesh_Unif+OPort2 out<export_all=2> {
		ndim => array_size(<-.in_dims);
		dims => <-.in_dims;
		nspace => ndim;
		points => {<-.init0, dims-1};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group rect_mesh {
	long+IPort2  in_dims[];
	float+IPort2 &in_points[][];

	int coord_dims[] => array_dims(in_points);

	int error => (array_size(in_dims)>0) && (array_size(in_points) >0) &&
		     ((array_size(coord_dims) != 2) || (sum(in_dims) != coord_dims[1]));
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "rect_mesh";
		error_message = "Invalid mesh: mesh dimensions and size of points do not match";
		on_inst = 1;
	};

	Mesh_Rect+OPort2  out {
		ndim => switch(!error,array_size(<-.in_dims));
		dims => switch(!error,<-.in_dims);
		nspace => switch(!error,<-.coord_dims[0]);
		points[] => switch(!error,<-.in_points);
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group struct_mesh {
	long+IPort2  in_dims[];
	float+IPort2 &coord[][];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(in_dims)>0) && (array_size(coord) >0) &&
		     ((array_size(coord_dims) != 2) || (prod(in_dims) != coord_dims[1]));
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "struct_mesh";
		error_message = "Invalid mesh: mesh dimensions and size of coordinates do not match";
		on_inst = 1;
	};

	Mesh_Struct+OPort2  out {
		ndim => switch(!error,array_size(<-.in_dims));
		dims => switch(!error,<-.in_dims);
		nspace =>  switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group point_mesh {
	float+IPort2 &coord[][];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "point_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};
	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Point cell_set {
			ncells => <-.nnodes;
			node_connect_list => switch(!error,init_array(ncells, 0, ncells-1));
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group line_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "line_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Line cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group line_disjoint_mesh {
	float+IPort2 &coord1[][];
	float+IPort2 &coord2[][];

	int coord_dims[] => array_dims(coord1);
	int n => coord_dims[1];

	int coord_dims2[] => array_dims(coord2);
	int n2 => coord_dims2[1];

	int error => (array_size(coord1)>0) && (array_size(coord2) >0) &&
		     ((array_size(coord_dims) != 2) || (array_size(coord_dims2) != 2) ||
		      (n != n2) || (coord_dims[0] != coord_dims2[0]));

	GMOD.print_error print_error {
		error => <-.error;
		error_source = "line_disjoint_mesh";
		error_message = "Invalid mesh: two coordinates arrays dimensions do not match";
		on_inst = 1;
	};


	int con1[n][1] => switch(!error,init_array(n, 0, n-1));
	int con2[n][1] => switch(!error,init_array(n, n, 2*n-1));
	Mesh+OPort2  out {
		nnodes => switch(!error,<-.n*2);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,concat_array(<-.<-.coord1, <-.<-.coord2));
		ncell_sets = 1;
		Line cell_set {
			ncells =>switch(!error, <-.<-.coord_dims[1]);
			node_connect_list[] => combine_array(<-.<-.con1, <-.<-.con2);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group tri_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "tri_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Tri cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group quad_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "quad_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Quad cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group polyline_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "polyline_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Polyline cell_set {
			npolys => switch(!error,array_size(<-.<-.connect)/2);
			poly_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};


group polytri_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "polyltry_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Polytri cell_set {
			npolys => switch(!error,array_size(<-.<-.connect)/2);
			poly_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group polyhedron_mesh {
	float+IPort2 &coord[][];
	int+IPort2 &poly_nodes[];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "polyhedron_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Polyhedron cell_set {
			npolys => switch(!error,array_size(<-.<-.poly_nodes));
			poly_nnodes => switch(!error,<-.<-.poly_nodes);
			poly_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group tet_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "tet_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Tet cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

group hex_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "hex_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Hex cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

group pyramid_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "pyramid_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Pyr cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

group prism_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "prism_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Prism cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

group line2_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "line_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Line2 cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};
group tri2_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "tri_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Tri2 cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group quad2_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "quad_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Quad2 cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};
group tet2_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "tet_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Tet2 cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

group hex2_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "hex_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Hex2 cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

group prism2_mesh {
	float+IPort2 &coord[][];
	long+IPort2 &connect[];

	int coord_dims[] => array_dims(coord);

	int error => (array_size(coord) >0) &&
		     (array_size(coord_dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "prism_mesh";
		error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
		on_inst = 1;
	};

	Mesh+OPort2  out {
		nnodes => switch(!error,<-.coord_dims[1]);
		nspace => switch(!error,<-.coord_dims[0]);
		coordinates.values => switch(!error,<-.<-.coord);
		ncell_sets = 1;
		Prism2 cell_set {
			ncells => switch(!error,array_size(<-.<-.connect)/cell_nnodes);
			node_connect_list => switch(!error,<-.<-.connect);
		};
	};
};

};

library+global+buffered Data_Mappers {

group node_scalar {
	prim+IPort2 &in_data[];
	
	Node_Data+OPort2 out {
		nnodes => switch((array_size(<-.in_data) >= 0), array_size(<-.in_data));
		nnode_data = 1;
		node_data {
			veclen = 1;
			values => <-.<-.in_data;
		};
	};
};

group node_vector {
	prim+IPort2 &in_data[][];
	long dims[] => array_dims(in_data);

	int error => (array_size(in_data) >0) &&
		     (array_size(dims) != 2);
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "node_vector";
		error_message = "Invalid data: should be 2d array [nnodes][veclen]";
		on_inst = 1;
	};

	Node_Data+OPort2 out {
		nnodes => switch(!error,<-.dims[1]);
		nnode_data = 1;
		node_data {
			veclen => switch(!<-.<-.error,<-.<-.dims[0]);
			values => switch(!<-.<-.error,<-.<-.in_data);
		};
	};
};

node_scalar radius_data {
	out {
		node_data {
			id = 668;
		};
	};
};

node_vector rgb_data {
	error => (array_size(in_data) >0) &&
		     ((array_size(dims) != 2) || (dims[0] !=3));
	print_error {
		error => <-.error;
		error_source = "rgb_data";
		error_message = "Invalid data: should be 2d array [nnodes][3]";
		on_inst = 1;
	};
	out {
		node_data {
			byte values[nvals][veclen] => switch(!<-.<-.error,<-.<-.in_data);
			id = 669;
		};
	};
};

node_vector argb_data {
	error => (array_size(in_data) >0) &&
		     ((array_size(dims) != 2) || (dims[0] !=4));
	print_error {
		error => <-.error;
		error_source = "argb_data";
		error_message = "Invalid data: should be 2d array [nnodes][4]";
		on_inst = 1;
	};
	out {
		node_data {
			byte values[nvals][veclen] => switch(!<-.<-.error,<-.<-.in_data);
			id = 669;
		};
	};
};

node_vector node_colors {
	error => (array_size(in_data) >0) &&
		     ((array_size(dims) != 2) || (dims[0] !=3));
	print_error {
		error => <-.error;
		error_source = "node_colors";
		error_message = "Invalid data: should be 2d array [nnodes][3]";
		on_inst = 1;
	};
	out {
		node_data {
			float values[nvals][veclen] => switch(!<-.<-.error,<-.<-.in_data);
			id = 667;
		};
	};
};

node_vector node_normals {
	error => (array_size(in_data) >0) &&
		     ((array_size(dims) != 2) || (dims[0] !=3));
	print_error {
		error => <-.error;
		error_source = "node_normals";
		error_message = "Invalid data: should be 2d array [nnodes][3]";
		on_inst = 1;
	};
	out {
		node_data {
			float values[nvals][veclen] => switch(!<-.<-.error,<-.<-.in_data);
			id = 666;
		};
	};
};

node_vector node_uv {
	error => (array_size(in_data) >0) &&
		     ((array_size(dims) != 2) || (dims[0] !=2));
	print_error {
		error => <-.error;
		error_source = "node_uv";
		error_message = "Invalid data: should be 2d array [nnodes][2]";
		on_inst = 1;
	};
	out {
		node_data {
			float values[nvals][veclen] => switch(!<-.<-.error,<-.<-.in_data);
			id = 670;
		};
	};
};

node_vector node_uvw {
	error => (array_size(in_data) >0) &&
		     ((array_size(dims) != 2) || (dims[0] !=3));
	print_error {
		error => <-.error;
		error_source = "node_uvw";
		error_message = "Invalid data: should be 2d array [nnodes][3]";
		on_inst = 1;
	};
	out {
		node_data {
			float values[nvals][veclen] => switch(!<-.<-.error,<-.<-.in_data);
			id = 670;
		};
	};
};
node_scalar pick_data {
	out {
		node_data {
			id = 671;
		};
	};
};

};

library+global+buffered Field_Mappers {

group uniform_scalar_field {
	uniform_mesh mesh {
		in_dims+IPort3;
	};
	
	node_scalar data {
		in_data+IPort3;
	};

	int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != array_size(data.in_data));
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "uniform_scalar_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Unif+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;

}; 

group uniform_vector_field {
	uniform_mesh mesh {
		in_dims+IPort3;
	};
	
	node_vector data {
		in_data+IPort3;
	};

	long dims[] => array_dims(data.in_data);

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != dims[1]);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "uniform_vector_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Unif+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 


group image_field {
	uniform_mesh mesh {
		in_dims+IPort3;
	};
	
	node_scalar data {
		in_data+IPort3;
	};

	long dims[] => array_dims(data.in_data);


        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (array_size(mesh.in_dims) !=2 || prod(mesh.in_dims) != array_size(data.in_data));
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "image_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Unif+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group image_field_rgb {
	uniform_mesh mesh {
		in_dims+IPort3;
	};
	
	rgb_data data {
		in_data+IPort3;
	};

	long dims[] => array_dims(data.in_data);

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (array_size(mesh.in_dims) !=2 || prod(mesh.in_dims) != dims[1]);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "image_field_rgb";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Unif+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group image_field_argb {
	uniform_mesh mesh {
		in_dims+IPort3;
	};
	
	argb_data data {
		in_data+IPort3;
	};

	long dims[] => array_dims(data.in_data);

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (array_size(mesh.in_dims) !=2 || prod(mesh.in_dims) != dims[1]);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "image_field_argb";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Unif+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group volume_field {
	uniform_mesh mesh {
		in_dims+IPort3;
	};
	
	node_scalar data {
		in_data+IPort3;
	};

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != array_size(data.in_data));
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "volume_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Unif+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group rect_scalar_field {
	rect_mesh mesh {
		in_dims+IPort3;
		in_points+IPort3;
	};
	
	node_scalar data {
		in_data+IPort3;
	};

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != array_size(data.in_data));
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "rect_scalar_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Rect+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group rect_vector_field {
	rect_mesh mesh {
		in_dims+IPort3;
		in_points+IPort3;
	};
	
	node_vector data {
		in_data+IPort3;
	};

	long dims[] => array_dims(data.in_data);

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != dims[1]);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "rect_vector_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Rect+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group struct_scalar_field {
	struct_mesh mesh {
		in_dims+IPort3;
		coord+IPort3;
	};
	
	node_scalar data {
		in_data+IPort3;
	};

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != array_size(data.in_data));
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "struct_scalar_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Struct+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

group struct_vector_field {
	struct_mesh mesh {
		in_dims+IPort3;
		coord+IPort3;
	};
	
	node_vector data {
		in_data+IPort3;
	};

	long dims[] => array_dims(data.in_data);

        int error => (array_size(mesh.in_dims)>0) && 
	             (array_size(data.in_data) >0) &&
		     (prod(mesh.in_dims) != dims[1]);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "struct_scalar_field";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

	Mesh_Struct+Node_Data+OPort2 &out => switch(!error, merge(mesh.out, data.out));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
}; 

};

library+buffered Combiners {

group concat_2_arrays {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	
	prim+OPort2 out[]=>concat_array(in1,in2);

};
group concat_3_arrays {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	prim+IPort2 &in3[];
	
	prim+OPort2 out[]=>concat_array(in1,in2,in3);

};
group concat_4_arrays {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	prim+IPort2 &in3[];
	prim+IPort2 &in4[];
	
	prim+OPort2 out[]=>concat_array(in1,in2,in3,in4);

};

group interleave_2_arrays {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	
	int dim1=>array_size(in1);
	int dim2=>array_size(in2);

        int error => (array_size(in1)>0) && (array_size(in2) >0) &&
		     (dim1 != dim2);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "interleave_2_arrays";
		error_message = "Invalid array dimensions: sizes do not match";
		on_inst = 1;
	};

	prim rin1[dim1][1] => in1;
	prim rin2[dim2][1] => in2;

	prim+OPort2 out[dim1][2]=>switch(!error, combine_array(rin1,rin2));

};

group interleave_3_arrays {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	prim+IPort2 &in3[];
	
	int dim1=>array_size(in1);
	int dim2=>array_size(in2);
	int dim3=>array_size(in3);

        int error => (array_size(in1)>0) && (array_size(in2) >0) && (array_size(in3) >0) &&
		     (dim1 != dim2 || dim1 != dim3);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "interleave_3_arrays";
		error_message = "Invalid array dimensions: sizes do not match";
		on_inst = 1;
	};

	prim rin1[dim1][1] => in1;
	prim rin2[dim2][1] => in2;
	prim rin3[dim3][1] => in3;

	prim+OPort2 out[dim1][3]=>switch(!error, combine_array(rin1,rin2,rin3));

};

group interleave_4_arrays {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	prim+IPort2 &in3[];
	prim+IPort2 &in4[];
	
	int dim1=>array_size(in1);
	int dim2=>array_size(in2);
	int dim3=>array_size(in3);
	int dim4=>array_size(in4);

        int error => (array_size(in1)>0) && (array_size(in2) >0) && 
		     (array_size(in3)>0) && (array_size(in4) >0) &&
		     (dim1 != dim2 || dim1 != dim3 || dim1 != dim4);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "interleave_4_arrays";
		error_message = "Invalid array dimensions: sizes do not match";
		on_inst = 1;
	};

	prim rin1[dim1][1] => in1;
	prim rin2[dim2][1] => in2;
	prim rin3[dim3][1] => in3;
	prim rin4[dim4][1] => in4;

	prim+OPort2 out[dim1][4]=>switch(!error, combine_array(rin1,rin2,rin3,rin4));

};

group combine_node_datas {
	Node_Data+IPort2 &in[] {
		nnode_data=1;
	};
	Node_Data+OPort2 out {
		nnodes => <-.in[0].nnodes;
		nnode_data => array_size(<-.in);
		&node_data => in.node_data[0];
	};
};
group combine_mesh_data {
	Mesh+IPort2 &in_mesh ;
   	Node_Data+nres+IPort2 &in_nd;

	int error => (is_valid(in_mesh.nnodes)) && (is_valid(in_nd.nnodes)) &&
		     (in_mesh.nnodes != in_nd.nnodes);
	
	GMOD.print_error print_error {
		error => <-.error;
		error_source = "combine_mesh_data";
		error_message = "Invalid field: mesh dimensions and size of data do not match";
		on_inst = 1;
	};

        Mesh+Node_Data+OPort2 &out => switch(!error, merge(in_nd, in_mesh));
	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
};

group combine_mesh_cell_data {
	Mesh+IPort2 &in_mesh {
		ncell_sets = 1;
	};
   	prim+IPort2 in_data[];

	long dims[] => array_dims(in_data);
	int veclen => switch(array_size(dims),1, dims[0]);
	long ndata => switch(array_size(dims),dims[0],dims[1]);

	group cell_data {
		int	ncell_data = 1;
		Data_Array  cell_data[ncell_data] { 
			nvals => <-.<-.ndata;
			veclen => <-.<-.veclen;
			values => <-.<-.in_data;
		};
	};
	group out_cells {
		int ncell_sets = 1;
		Cell_Set &cell_set => merge (cell_data, in_mesh.cell_set);
	};
		


        Mesh+Cell_Data+OPort2 &out => merge(out_cells, in_mesh);


	DataObject DataObject {
		in => <-.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
    	};
    	olink obj => DataObject.obj;
/**
	group foo[ncell_sets] {
		group cell_data {
			int	ncell_data = 1;
			Data_Array  cell_data[ncell_data] { 
				nvals => in_mesh.cell_set[index_of(foo)].ncells;
				veclen = 1;
				values => in_data;
			};
		};
		Cell_Set &cell_set => merge(cell_data,in_mesh.cell_set[index_of(foo)]);  
	};
	Mesh {
		&cell_set => merge(cell_data,in_mesh.cell_set[index_of(foo)]);
	};
*/

};

};

library+global+buffered Array_Extractors {
group extract_coordinate_array {
	Mesh+IPort2 &in;

	int comp[]={0};

	DVxform_coord DVxform_coord{
		in => <-.in;
		comp => <-.comp;
	};
	
	UImod_panel UIpanel<NEy=132,NEx=165> {
		parent<NEportLevels={3,0}>;
		title => name_of(<-.<-);
		message = "Select Extract_Coordinates control panel.";
		rowColumnBehavior = 1;
	};
	UIoptionBoxLabel  UIoptionBoxLabel{
		parent => <-.UIpanel;
		labels => {" X "," Y "," Z "};
	    	max = 3;
	    	&selectedItems+IPort2 => <-.comp;
		visible => <-.UIpanel.visible;
		title = "Select Coordinates";
	};
	olink coord=>DVxform_coord.coord;
};

group extract_data_array {
	Node_Data+IPort2 &in;
	int+IPort2 comp=0;
	prim+OPort2 data[]=>in.node_data[comp].values;
	string+OPort2 &label=>in.node_data[comp].labels;
	DVnode_data_labels DVnode_data_labels {
		in => <-.in;
		int+nres  ncomp => <-.in.nnode_data;
	};

	UImod_panel UIpanel<NEy=132,NEx=165> {
		parent<NEportLevels={3,0}>;
		title => name_of(<-.<-);
		message = "Select Extract_Coordinates control panel.";
		rowColumnBehavior = 1;
	};
	UIradioBoxLabel   UIradioBoxLabel_mode2{
	        parent => <-.UIpanel;
		labels+IPort2 => <-.DVnode_data_labels.labels;
		&selectedItem+IPort2 => <-.comp;
		visible => <-.UIpanel.visible;
		title = "Select Data Component";
	};
};

};

};
