/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/fld_meth.v#1 $
*/

flibrary+global+sort DV_FLD <NEvisible=0,
   build_dir="mod_util",
   build_cmd="$(MAKE)",
   user_library=0,
   compile_subs=0,	// don't redeclare virtual functions
   indexed=0, 		// has virtual data... don't index
   link_files="-lmutil",
   hdr_code="int FLD_METHinit (void);",
   // need to do this by hand since they are virtual...
   init_code="   FLD_METHinit();"
> {

Mesh Mesh {
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      };

	dgroup+virtual methods {
		func interp_init_func = "interp_init_func";
		func find_cell_func = "find_cell_func";
		func interp_cell_func = "interp_cell_func";
		func interp_data_func = "interp_data_func";
		func cell_extent_func = "cell_extent_func";
		func coord_list_func = "coord_list_func";
		func data_list_func = "data_list_func";
		func isosurf_func = "isosurf_func";
		func isoline_func = "isoline_func";
		func cut_func = "cut_func";
		func contour_func = "contour_func";
		func eval_coord_func = "eval_coord_func";
		func glyph_func = "glyph_func";
		func thresh_null_func = "thresh_null_func";
		func grad_func = "grad_func";
		func curl_func = "curl_func";
		func div_func = "div_func";
		func deriv3d_func = "deriv3d_func";
		func deriv2d_func = "deriv2d_func";
		func cell_to_node_func = "cell_to_node_func";
	};
};

Mesh_Struct Mesh_Struct {
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      };

	dgroup+virtual methods {
		func interp_init_func = "interp_init_func_struct";
		func find_cell_func = "find_cell_func_struct";
		func interp_cell_func = "interp_cell_func_struct";
		func interp_data_func = "interp_data_func_struct";
		func cell_extent_func = "cell_extent_func_struct";
		func coord_list_func = "coord_list_func_struct";
		func data_list_func = "data_list_func_struct";
		func isosurf_func = "isosurf_func_struct";
		func isoline_func = "isoline_func_struct";
		func cut_func = "cut_func_struct";
		func contour_func = "contour_func_struct";
		func eval_coord_func = "eval_coord_func_struct";
		func glyph_func = "glyph_func_struct";
		func thresh_null_func = "thresh_null_func_struct";
		func grad_func = "grad_func_struct";
		func curl_func = "curl_func_struct";
		func div_func = "div_func_struct";
		func deriv3d_func = "deriv3d_func_struct";
		func deriv2d_func = "deriv2d_func_struct";
		func cell_to_node_func = "cell_to_node_func_struct";
	};
};

Mesh_Unif Mesh_Unif {
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      };

	dgroup+virtual methods {
		func interp_init_func = "interp_init_func_unif";
		func find_cell_func = "find_cell_func_unif";
		func interp_cell_func = "interp_cell_func_unif";
		func interp_data_func = "interp_data_func_unif";
		func cell_extent_func = "cell_extent_func_unif";
		func coord_list_func = "coord_list_func_unif";
		func data_list_func = "data_list_func_unif";
		func isosurf_func = "isosurf_func_unif";
		func isoline_func = "isoline_func_unif";
		func cut_func = "cut_func_unif";
		func contour_func = "contour_func_unif";
		func eval_coord_func = "eval_coord_func_unif";
		func glyph_func = "glyph_func_unif";
		func thresh_null_func = "thresh_null_func_unif";
		func rslice_func = "rslice_func_unif";
		func grad_func = "grad_func_unif";
		func curl_func = "curl_func_unif";
		func div_func = "div_func_unif";
		func deriv3d_func = "deriv3d_func_unif";
		func deriv2d_func = "deriv2d_func_unif";
		func cell_to_node_func = "cell_to_node_func_unif";
	};
};

Mesh_Rect Mesh_Rect {
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      };

	dgroup+virtual methods {
		func interp_init_func = "interp_init_func_rect";
		func find_cell_func = "find_cell_func_rect";
		func interp_cell_func = "interp_cell_func_rect";
		func interp_data_func = "interp_data_func_rect";
		func cell_extent_func = "cell_extent_func_rect";
		func coord_list_func = "coord_list_func_rect";
		func data_list_func = "data_list_func_rect";
		func isosurf_func = "isosurf_func_rect";
		func isoline_func = "isoline_func_rect";
		func cut_func = "cut_func_rect";
		func contour_func = "contour_func_rect";
		func eval_coord_func = "eval_coord_func_rect";
		func glyph_func = "glyph_func_rect";
		func thresh_null_func = "thresh_null_func_rect";
		func rslice_func = "rslice_func_rect";
		func grad_func = "grad_func_rect";
		func curl_func = "curl_func_rect";
		func div_func = "div_func_rect";
		func deriv3d_func = "deriv3d_func_rect";
		func deriv2d_func = "deriv2d_func_rect";
		func cell_to_node_func = "cell_to_node_func_rect";
	};
};

Line Line {
     dgroup+virtual methods {
	func shape_func = "shape_func_line_1";
	func shape_deriv_func = "shape_deriv_line_1";
	func rev_par_func = "rev_par_line_1";
	func cut_func = "cut_cell_line_1";
	func vol_integr_func = "vol_integr_line_1";
     };
};

Polyline Polyline {
     dgroup+virtual methods {
	func shape_func = "shape_func_line_1";
	func shape_deriv_func = "shape_deriv_line_1";
	func rev_par_func = "rev_par_line_1";
	func vol_integr_func = "vol_integr_line_1";
     };
};

Line2 Line2 {
     dgroup+virtual methods {
	func shape_func = "shape_func_line_2";
	func shape_deriv_func = "shape_deriv_line_2";
	func rev_par_func = "rev_par_line_2";
	func cut_func_tesselate  = "cut_cell_line_1";
	func vol_integr_func = "vol_integr_line_1";
	func tesselate_func = "tesselate_line_2";
     };
};

Tri Tri {
     dgroup+virtual methods {
	func shape_func = "shape_func_tri_1";
	func shape_deriv_func = "shape_deriv_tri_1";
	func rev_par_func = "rev_par_tri_1";
	func isoline_func = "isoline_tri_1";
	func cut_func = "cut_cell_tri_1";
	func contour_func = "contour_cell_tri_1";
	func vol_integr_func = "vol_integr_tri_1";
     };
};

Polytri Polytri {
     dgroup+virtual methods {
	func shape_func = "shape_func_tri_1";
	func shape_deriv_func = "shape_deriv_tri_1";
	func rev_par_func = "rev_par_tri_1";
	func isoline_func = "isoline_tri_1";
	func cut_func = "cut_cell_tri_1";
	func contour_func = "contour_cell_tri_1";
	func vol_integr_func = "vol_integr_tri_1";
     };
};

Tri2 Tri2 {
     dgroup+virtual methods {
	func shape_func = "shape_func_tri_2";
	func shape_deriv_func = "shape_deriv_tri_2";
	func rev_par_func = "rev_par_tri_2";
	func isoline_func_tesselate = "isoline_tri_1";
	func cut_func_tesselate  = "cut_cell_tri_1";
	func contour_func_tesselate  = "contour_cell_tri_1";
	func vol_integr_func = "vol_integr_tri_1";
	func tesselate_func = "tesselate_tri_2";
     };
};

Quad Quad {
     dgroup+virtual methods {
	func shape_func = "shape_func_quad_1";
	func shape_deriv_func = "shape_deriv_quad_1";
	func rev_par_func = "rev_par_quad_1";
	func isoline_func = "isoline_quad_1";
	func cut_func = "cut_cell_quad_1";
	func contour_func = "contour_cell_quad_1";
	func vol_integr_func = "vol_integr_quad_1";
     };
};

Quad2 Quad2 {
     dgroup+virtual methods {
	func shape_func = "shape_func_quad_2";
	func shape_deriv_func = "shape_deriv_quad_2";
	func rev_par_func = "rev_par_quad_2";
	func isoline_func_tesselate  = "isoline_tri_1";
	func cut_func_tesselate  = "cut_cell_tri_1";
	func contour_func_tesselate  = "contour_cell_tri_1";
	func vol_integr_func = "vol_integr_quad_1";
	func tesselate_func = "tesselate_quad_2";
     };
};

Tet Tet {
     dgroup+virtual methods {
	func shape_func = "shape_func_tet_1";
	func shape_deriv_func = "shape_deriv_tet_1";
	func rev_par_func = "rev_par_tet_1";
	func slice_func = "slice_cell_tet_1";
	func cut_func = "cut_cell_tet_1";
	func contour_func = "contour_cell_tet_1";
	func vol_integr_func = "vol_integr_tet_1";
     };
};

Tet2 Tet2 {
     dgroup+virtual methods {
	func shape_func = "shape_func_tet_2";
	func shape_deriv_func = "shape_deriv_tet_2";
	func rev_par_func = "rev_par_tet_2";
	func slice_func_tesselate = "slice_cell_tet_1";
	func cut_func_tesselate = "cut_cell_tet_1";
	func contour_func_tesselate = "contour_cell_tet_1";
	func vol_integr_func = "vol_integr_tet_1";
	func tesselate_func = "tesselate_tet_2";
     };
};

Hex Hex {
     dgroup+virtual methods {
	func shape_func = "shape_func_hex_1";
	func shape_deriv_func = "shape_deriv_hex_1";
	func rev_par_func = "rev_par_hex_1";
	func slice_func = "slice_cell_hex_1";
	func cut_func = "cut_cell_hex_1";
	func contour_func = "contour_cell_hex_1";
	func vol_integr_func = "vol_integr_hex_1";
     };
};

Hex2 Hex2 {
     dgroup+virtual methods {
	func shape_func = "shape_func_hex_2";
	func shape_deriv_func = "shape_deriv_hex_2";
	func rev_par_func = "rev_par_hex_2";
	func slice_func_tesselate = "slice_cell_tet_1";
	func cut_func_tesselate = "cut_cell_tet_1";
	func contour_func_tesselate = "contour_cell_tet_1";
	func vol_integr_func_tesselate = "vol_integr_hex_1";
	func tesselate_func = "tesselate_hex_2";
     };
};

Pyr Pyr {
     dgroup+virtual methods {
	func shape_func = "shape_func_pyr_1";
	func shape_deriv_func = "shape_deriv_pyr_1";
	func rev_par_func = "rev_par_pyr_1";
	func slice_func = "slice_cell_pyr_1";
	func contour_func = "contour_cell_pyr_1";
	func cut_func = "cut_cell_pyr_1";
     };
};

Prism Prism {
     dgroup+virtual methods {
	func shape_func = "shape_func_prism_1";
	func shape_deriv_func = "shape_deriv_prism_1";
	func rev_par_func = "rev_par_prism_1";
	func slice_func = "slice_cell_prism_1";
	func cut_func = "cut_cell_prism_1";
	func contour_func = "contour_cell_prism_1";
	func vol_integr_func = "vol_integr_prism_1";
     };
};

Prism2 Prism2 {
     dgroup+virtual methods {
	func shape_func = "shape_func_prism_2";
	func shape_deriv_func = "shape_deriv_prism_2";
	func rev_par_func = "rev_par_prism_2";
	func slice_func_tesselate = "slice_cell_tet_1";
	func cut_func_tesselate = "cut_cell_tet_1";
	func contour_func_tesselate = "contour_cell_tet_1";
	func vol_integr_func = "vol_integr_prism_1";
	func tesselate_func = "tesselate_prism_2";
     };
};


Polyhedron Polyhedron {
     dgroup+virtual methods {
	func shape_func = "shape_func_tri_1";
	func shape_deriv_func = "shape_deriv_tri_1";
	func rev_par_func = "rev_par_tri_1";
	func isoline_func = "isoline_tri_1";
	func cut_func = "cut_cell_tri_1";
	func contour_func = "contour_cell_tri_1";
	func vol_integr_func = "vol_integr_tri_1";
     };
};

};
