/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDaccel2.v#1 $
*/

APPS.SingleWindowApp AccelGraphSlice<NEdisplayMode="maximized",
                                     NEhelpTopic="gdex_AccelGraphSlice"> {

MODS.Readers.Read_Field Read_Field<NEx=473.,NEy=66.> {
   read_field_ui {
      filename = "$XP_PATH<0>/data/field/helens2.fld";
   };
};
MODS.Readers.Loop Loop<NEx=187.,NEy=77.> {
   end = 325.;
   incr = 4.;
};
macro DynamicGraphMacro<NEx=308.,NEy=275.,NEwidth=286.> {
   Axes.AGXAxis AGXAxis<NEx=561.,NEy=44.,NEwidth=187.,NEheight=231.> {
      majorTickColor => <-.AGXTicklines.majorTickColor;
      majorTickLineStyle => <-.AGXTicklines.majorTickLineStyle;
      majorTickWidth => <-.AGXTicklines.majorTickWidth;
      minorTickColor => <-.AGXTicklines.minorTickColor;
      minorTickCount => <-.AGXTicklines.minorTickCount;
      minorTickLineStyle => <-.AGXTicklines.minorTickLineStyle;
      minorTickWidth => <-.AGXTicklines.minorTickWidth;
   };
   Axes.AGYAxis AGYAxis<NEx=561.,NEy=110.> {
      majorTickColor => <-.AGYTicklines.majorTickColor;
      majorTickLineStyle => <-.AGYTicklines.majorTickLineStyle;
      majorTickWidth => <-.AGYTicklines.majorTickWidth;
      minorTickColor => <-.AGYTicklines.minorTickColor;
      minorTickCount => <-.AGYTicklines.minorTickCount;
      minorTickLineStyle => <-.AGYTicklines.minorTickLineStyle;
      minorTickWidth => <-.AGYTicklines.minorTickWidth;
   };
   Axes.AGYTicklines AGYTicklines<NEx=561.,NEy=143.,NEwidth=198.,NEheight=220.> {
      minorTickCount = 2;
   };
   Axes.AGXTicklines AGXTicklines<NEx=561.,NEy=77.,NEwidth=220.,NEheight=220.> {
      minorTickCount = 4;
   };
   Graphing.AGGraphWorld AGGraphWorld<NEx=528.,NEy=264.,NEwidth=231.,NEheight=297.> {
      children => {<-.AGXAxis,
         <-.AGXTicklines,<-.AGYAxis,<-.AGYTicklines};
      limitsX = {0.,450.};
      limitsY = {0.,2550.};
   };
   AGText graphTitle<NEx=341.,NEy=231.,NEwidth=297.,NEheight=220.> {
      geometry = {0.,5.5};
      font = "Helvetica";
      text = {
         "Dynamic Graph Demo"};
      verticalJustification = "bottom";
      height = 10.;
   };
   Graphing.AGGraphViewportObj AGGraphViewportObj#1<NEx=429.,NEy=363.,NEscalingFactor=1.,NExOffset=0.,NEyOffset=0.> {
      graphViewport<NEx=11.,NEy=55.,NEwidth=242.,NEheight=275.> {
         children => {<-.<-.graphTitle,
            <-.<-.AGGraphWorld};
      };
      macro dataObject {
         AGGeometryPrimitive &in<NEportLevels={2,1},NEnumColors=2,NEcolor1=255,NEy=55,NEx=55> => <-.graphViewport;
         DefaultDatamap Datamap<NEy=132,NEx=77> {
            dataMin => <-.DefaultMinMax.min_value;
            dataMax => <-.DefaultMinMax.max_value;
         };
         GD.DefaultMinMax DefaultMinMax<NEx=231,NEy=55> {
            Node_Data+read &input<NEportLevels={3,0},NEnumColors=4,NEcolor0=255> {
               data_method render;
            };
         };
         DefaultProps Props<NEy=143,NEx=308> {
            inherit = 0;
         };
         DefaultObject StaticObj<NEx=77.,NEy=352.,NEportLevels={0,1}> {
            input => <-.in;
            dmap => <-.Datamap;
            xform => <-.Xform;
            props => <-.Props;
            modes => <-.Modes;
            pick_info => <-.PickInfo;
            string name => name_of(<-.<-.<-);
         };
         olink obj<NEy=352,NEx=297,NEportLevels={1,4}> => .StaticObj;
         DefaultModes Modes<NEy=110,NEx=363>;
         DefaultXform Xform<NEy=176,NEx=253>;
         DefaultPickInfo PickInfo<NEy=77,NEx=429>;
      };
   };
   Graphing.AGGraphViewportObj AGGraphViewportObj<NEx=220.,NEy=363.> {
      macro dataObject {
         AGGeometryPrimitive &in<NEportLevels={2,1},NEnumColors=2,NEcolor1=255,NEy=55,NEx=55> => <-.graphViewport;
         DefaultDatamap Datamap<NEy=132,NEx=77> {
            dataMin => <-.DefaultMinMax.min_value;
            dataMax => <-.DefaultMinMax.max_value;
         };
         GD.DefaultMinMax DefaultMinMax<NEx=231,NEy=55> {
            Node_Data+read &input<NEportLevels={3,0},NEnumColors=4,NEcolor0=255> {
               data_method render;
            };
         };
         DefaultProps Props<NEy=143,NEx=308> {
            inherit = 0;
         };
         DefaultObject DynamicObj<NEportLevels={0,1},NEy=352.,NEx=77.> {
            input => <-.in;
            dmap => <-.Datamap;
            xform => <-.Xform;
            props => <-.Props;
            modes => <-.Modes;
            type = 1;
            pick_info => <-.PickInfo;
            string name => name_of(<-.<-.<-);
         };
         olink obj<NEy=352,NEx=297,NEportLevels={1,4}> => .DynamicObj;
         DefaultModes Modes<NEy=110,NEx=363>;
         DefaultXform Xform<NEy=176,NEx=253>;
         DefaultPickInfo PickInfo<NEy=77,NEx=429>;
      };
      graphViewport<NEx=11.,NEy=55.,NEwidth=264.,NEheight=242.> {
         children => {
            <-.<-.AGGraphWorld#1};
         fillColor = "transparent";
      };
   };
   Graphing.AGGraphWorld AGGraphWorld#1<NEx=143.,NEy=253.,NEwidth=209.,NEheight=242.> {
      children => {<-.AGGraph};
      limitsX = {0.,450.};
      limitsY = {0.,2550.};
   };
   Graphing.AGGraph AGGraph<NEx=143.,NEy=121.,NEwidth=242.,NEheight=275.> {
      valuesY<NEportLevels={3,0}> => <-.<-.extract_data_array.data;
      lineWidth = 0.1;
   };
};
MODS.Mappers.orthoslice orthoslice<NEx=385.,NEy=143.> {
   in_field => <-.Read_Field.field;
   OrthoSliceParam<NEx=11.,NEy=55.> {
      plane<NEportLevels={3,2}> => <-.<-.Loop.count;
   };
};
FLD_MAP.Array_Extractors.extract_data_array extract_data_array<NEx=385.,NEy=198.> {
   in => <-.orthoslice.out_fld;
};
GDM.Uviewer2D Uviewer2D<NEx=308.,NEy=374.> {
   Scene {
      Top {
         child_objs => {DynamicGraphMacro.AGGraphViewportObj#1.dataObject.obj,
            DynamicGraphMacro.AGGraphViewportObj.dataObject.obj};
      };
      Camera {
         Camera {
            auto_norm = 0;
         };
      };
      View {
         View {
            accel = 1;
         };
         VirtPal {
            vclass = 3;
         };
      };
   };
};

};
