/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDaccel3.v#1 $
*/

APPS.SingleWindowApp Accel3DProbe<NEdisplayMode="maximized",
                                  NEhelpTopic="gdex_Accel3DProbe"> {

GEOMS.Axis3D Axis3D<NEx=33.,NEy=242.> {
   in_field => <-.city_plot.out_fld;
};
MODS.city_plot city_plot<NEx=198.,NEy=176.> {
   in_field<NEportLevels={2,1}> => <-.reset_xform.out_fld;
   obj {
      PickInfo {
         src_field<NEportLevels={3,1}> => <-.<-.in_field;
      };
   };
   CityParam<NEx=11.,NEy=55.> {
      scale<NEdisplayMode="open"> = 0.1;
      x_scale = 0.75;
      y_scale = 0.75;
   };
};

GDM.Uviewer3D Uviewer3D<NEx=33.,NEy=308.> {
   Scene {
      Top {
         child_objs => {text_glyph.out_obj,Axis3D.out_obj,city_plot.out_obj};
         Xform {
            mat = {
               -0.0525547,-0.0431914,0.0822884,0.,
               0.0913621,-0.0413297,0.0366564,0.,
               0.0170253,0.0884604,0.0573043,0.,
               0.,0.,0.,1.
            };
            xlate = {-1.34062,1.56367,-4.42654};
         };
      };
      View {
         PickCtrl {
            on_start = 0;
         };
         View {
            accel = 1;
            renderer = 0;
         };
      };
   };
};
MODS.Read_Field Read_Field<NEx=33.,NEy=11.> {
   DVread_field {
      Mesh_Unif+Node_Data Output_Field;
   };
   read_field_ui {
      file_browser<NEx=11.,NEy=187.> {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
};
MODS.orthoslice orthoslice<NEx=198.,NEy=88.> {
   in_field => <-.downsize.out_fld;
   OrthoSliceParam<NEx=11.,NEy=55.> {
      axis = 2;
   };
};
MODS.downsize downsize<NEx=33.,NEy=55.> {
   in_field => <-.Read_Field.field;
   DownsizeParam {
      factor0 = 2.;
      factor1 = 2.;
      factor2 = 2.;
   };
   DownsizeUI {
      panel {
         option {
            set = 1;
         };
      };
   };
};
FLD_MAP.point_mesh point_mesh<NEx=220.,NEy=374.> {
   coord => <-.GDpick_process#1.point;
   out<NEdisplayMode="open">;
};
MODS.text_glyph text_glyph<NEx=143.,NEy=451.,NExOffset=0.,NEyOffset=0.,NEscalingFactor=1.> {
   in_mesh => <-.set_xform.out_fld;
   in_text => <-.GDpick_process#1.value;
   TextUI<NEscalingFactor=1.038870811,NExOffset=-8.774108887,NEyOffset=-7.539367676> {
      Leadline<NEx=165.,NEy=231.> {
         set = 1;
      };
      Offset<NEx=165.,NEy=319.> {
         set = 1;
      };
   };
   TextValues<NEx=11.,NEy=143.>;
   obj {
      Obj {
         type = 1;
      };
   };
};
MODS.set_xform set_xform<NEx=385.,NEy=418.> {
   in_field1 => <-.point_mesh.out;
   in_field2 => <-.city_plot.out_fld;
};
GDpick_process GDpick_process#1<NEx=220.,NEy=319.,NEwidth=308.,NEheight=231.> {
   obj_in => <-.city_plot.out_obj;
};
MODS.reset_xform reset_xform<NEx=198.,NEy=132.> {
   in_field => <-.orthoslice.out_fld;
};
};
