/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gdif.v#1 $
*/	

$include ../include/avs/gd_def.h

flibrary+global+sort GDIF <
   build_dir="gdif",
   build_cmd="$(MAKE)",
#ifndef NO_DL_LOAD
   in_dll=1,
#endif
   link_files="-lgdif"
> {

library+sort Templates {
   /* Definition of a properties object. */
   group+OPort GDprops_templ {
      float+read col<animate=1>[3];
      float      hi1_col<animate=1>[3];
      float      hi2_col<animate=1>[3];
      float      material<animate=1>[4];
      float      spec_col<animate=1>[3];
      float      trans<animate=1>;
      enum draw_mode {
         choices = {"Copy", "XOR"};
      };
      int        line_width<animate=1>;
      enum line_style {
         choices = {"Solid", "Dashed", "Dotted", "DashDot"};
      };
      int        line_aa;
      float      dir_pt_size<animate=1>;
      int        subdiv<animate=1>;
      int        jitter<animate=1>;
      enum cull {
         choices = {"Normal", "Back", "Front", "Flip Normals"};
      };
      enum voxel_interp {
         choices = {"Point", "Trilinear"};
      };
      enum ray_algo {
         choices = {"Direct Composite", "Average", "Maximum", "Distance to Max", "SFP"};
      };
      enum ray_norm {
         choices = {"Global", "View", "Ray"};
      };
      int        fat_ray;
      float	 sfp_absorb;
      float	 sfp_emit;
      string     font;
      int        inherit;
      ptr+nonotify local_ptr<NEvisible=0>;
   };

   GDprops_templ GDprops<cxx_name="GDXprops"> {
      local_ptr+write;
      method+notify_inst+notify_val upd_func = "GDprops_update";
      method+notify_deinst del_func = "GDprops_delete";
   };

   /* Definition of a transformation object. */
   group+OPort GDxform_templ {
      float+opt+read	 mat<animate=1>[4][4];
      float+opt		 xlate<animate=1>[3];
      float+opt          center<animate=1>[3];
      float+nonotify+opt ocenter<NEvisible=0>[3];
      float+nonotify+opt dcenter<NEvisible=0>[3];
      int                rspace<NEvisible=0>;
   };
   GDxform_templ GDxform<NEsmallPixmapName="xform.bmx",cxx_name="GDXxform">;

   /* Definition of a modes object.  Modes are composed
      of draw / shade modes, normal usage modes, color
      usage modes and visiblity modes.
      Modes are associated with a GDobject.
   */
   group GDmodes_templ {
      int+read mode<animate=1>[5];
      enum normals {
	 choices = {"Inherit", "None", "Vertex"};
      };
      enum colors {
	 choices = {"Inherit", "None", "Facet", "Vertex"};
      };
      enum outline {
	 choices = {"On", "Off"};
      };
      ptr+nonotify local_ptr<NEvisible=0>;
   };
   GDmodes_templ+OPort GDmodes<cxx_name="GDXmodes"> {
      local_ptr+write;
      method+notify_inst+notify_val upd_func = "GDmodes_update";
      method+notify_deinst del_func = "GDmodes_delete";
   };

   group+OPort GDpick_data<cxx_name="GDXpick_data"> {
      int sx;
      int sy;
      float vert[3];
      float point[3];
      int verti;
      int conni;
      int primi;
      float dist;
      group &field_id;		/* field id */
      prim &values_id[];	/* values array id */
      group &data_id;		/* cell set id */
   };

   group+OPort GDpick_info_templ {
      float+read   objxform[4][4];
      float        topxform[4][4];
      float        viewxform[4][4];
      int          selected;
      int          npicked;
      GDpick_data  pick_data[npicked];
      /* Source field that the picked field was generated from. */
      group        &src_field;
      /* Pick path ids - use groups here to avoid 
	 introducing dependencies on gd.v.
      */
      group        &view;
      group        &camera;
      int          nobjs;
      group        *objects[nobjs];
      ptr+nonotify local_ptr<NEvisible=0>;
   };
   GDpick_info_templ GDpick_info<cxx_name="GDXpick_info"> {
      method+notify_deinst del_func = "GDpick_info_delete";
   };

   /* Defintion of a lights object. Very similar an AVS lights. 
      Lights are associated with a view. Lights may be shared
      among views if desired.
   */
   group+OPort GDlight_templ {
      enum+read type {
         choices = {"Directional", "Point", "Spot", "BiDirectional"};
      };
      int        state;
      float      col<animate=1>[3];
      float      att<animate=1>[2];
      float      concen<animate=1>;
      float      angle<animate=1>;
      GDxform_templ+IPort2 &xform;
      ptr+nonotify local_ptr<NEvisible=0>;
   };
   GDlight_templ GDlight<NEsmallPixmapName="light.bmx",cxx_name="GDXlight"> {
      local_ptr+write;
      method+notify_inst+notify_val upd_func = "GDlight_update";
      method+notify_deinst del_func = "GDlight_delete";
   };

   group+OPort GDlight_info_templ {
      int+read  show_lights;
      int       amb_state;
      float     amb_col<animate=1>[3];
      int       nlights;
      GDlight_templ+IPort2+read &lights[];
      ptr+nonotify local_ptr<NEvisible=0>;
   };
   GDlight_info_templ GDlight_info<cxx_name="GDXlight_info"> {
      nlights => array_size(lights);
      local_ptr+write;
      method+notify_inst+notify_val upd_func = "GDlight_info_update";
      method+notify_deinst del_func = "GDlight_info_delete";
   };

   group+OPort GDpick_ctrl_templ {
      int+IPort2+read x;
      int+IPort2      y;
      int+IPort2      event;
      int             mode;		/* pick first, all, or append */
      int             on_start;		/* if 1, pick only on start event */
   };
   GDpick_ctrl_templ GDpick_ctrl;
};

GDprops DefaultProps {
   col          = { GD_DEFAULT_RED, GD_DEFAULT_GREEN, GD_DEFAULT_BLUE };
   hi1_col      = { GD_DEFAULT_RED, GD_DEFAULT_GREEN, GD_DEFAULT_BLUE };
   hi2_col      = { GD_DEFAULT_RED, 0.0, 0.0 };
   material     = { GD_DEFAULT_AMBIENT, GD_DEFAULT_DIFFUSE,
                    GD_DEFAULT_SPECULAR, GD_DEFAULT_SPEC_EXP };
   spec_col     = { GD_DEFAULT_RED, GD_DEFAULT_GREEN, GD_DEFAULT_BLUE };
   trans        = GD_DEFAULT_TRANS;
   draw_mode    = GD_DEFAULT_DRAW_MODE;
   line_width   = GD_DEFAULT_LINE_WIDTH;
   line_style   = GD_DEFAULT_LINE_STYLE;
   line_aa      = GD_DEFAULT_LINE_AA;
   dir_pt_size  = GD_DEFAULT_DIR_PT_SIZE;
   subdiv       = GD_DEFAULT_SUBDIV;
   jitter       = GD_DEFAULT_JITTER;
   cull         = GD_DEFAULT_CULL;
   voxel_interp = GD_DEFAULT_VOX_INTERP;
   ray_algo     = GD_DEFAULT_RAY_ALGO;
   ray_norm     = GD_DEFAULT_RAY_NORM;
   fat_ray      = GD_DEFAULT_FAT_RAY;
   sfp_absorb	= GD_DEFAULT_SFP_ABSORB;
   sfp_emit	= GD_DEFAULT_SFP_EMIT;
   font         = GD_DEFAULT_FONT;
   inherit      = 1;
};

GDxform DefaultXform {
   mat<animate=1>[4][4]  = {{1.0, 0.0, 0.0, 0.0},
		 	    {0.0, 1.0, 0.0, 0.0},
		 	    {0.0, 0.0, 1.0, 0.0},
		 	    {0.0, 0.0, 0.0, 1.0}};
   xlate<animate=1>[3]   = {0.0, 0.0, 0.0};
   center<animate=1>[3]  = {0.0, 0.0, 0.0};
   ocenter[3] 		 = {0.0, 0.0, 0.0};
   dcenter[3] 		 = {0.0, 0.0, 0.0};
   rspace     		 = GD_DEFAULT_RSPACE; 
};

GDmodes DefaultModes {
   /* all modes inherit */
   mode[5] = { GD_POINTS_INHERIT, GD_LINES_INHERIT,
               GD_SURF_INHERIT, GD_VOLUME_INHERIT, GD_BOUNDS_INHERIT };
   normals = GD_NORMALS_INHERIT;
   colors  = GD_COLORS_INHERIT;
   outline = GD_OUTLINE_ON;
};

GDpick_info DefaultPickInfo;

GDlight DefaultLight {
   type   = GD_DEFAULT_LIGHT_TYPE;
   state  = 0;
   col    = { GD_DEFAULT_RED, GD_DEFAULT_GREEN, GD_DEFAULT_BLUE };
   att    = { GD_DEFAULT_ATTEN, GD_DEFAULT_ATTEN };
   concen = GD_DEFAULT_CONCEN;
   angle  = GD_DEFAULT_ANGLE;
};

GDlight DefaultLightOn {
   type   = GD_LIGHT_DIR;
   state  = 1;
   col    = { GD_DEFAULT_RED, GD_DEFAULT_GREEN, GD_DEFAULT_BLUE };
   att    = { GD_DEFAULT_ATTEN, GD_DEFAULT_ATTEN };
   concen = GD_DEFAULT_CONCEN;
   angle  = GD_DEFAULT_ANGLE;
};

GDlight_info DefaultLightInfo {
   show_lights = 0;
   amb_state = 1;
   amb_col = { GD_DEFAULT_RED, GD_DEFAULT_GREEN, GD_DEFAULT_BLUE };
};

GDpick_ctrl DefaultPickCtrl {
   x = 0;
   y = 0;
};

};
