/*
                        Copyright (c) 1998 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/gis1.v#1 $
*/

flibrary+buffered GIS<NEeditable=1,
	libdeps="FLD GIS_UTIL GIS_MODS",
	build_dir="gis/xp_mods",
	use_src_file=0,
	disabled => Templates.CONFIG.gis_disabled> {

// compile_src=0 is a undocumented and unsupported property that
// has the effect of not including the autogenerated C++ files in the
// autogenerated makefiles.  In this case, files such as GISll.cxx are
// directly included in one of the gis makefiles, rather than in express.mk.
// It has to be in each module, doesn't work to set it in the library.

    module GISLatLon<cxx_class="LatLon",
	cxx_hdr_files="avs/gis/latlon.h",
	out_hdr_file="GISll.hxx",
	out_src_file="GISll.cxx",
	compile_src=0
	> {
         double+read+notify+req latDegree<NEportLevels={2,0}> = 0.;
         double+read+notify+req latMinute<NEportLevels={2,0}> = 0.;
         double+read+notify+req latSecond<NEportLevels={2,0}> = 0.;
         double+read+notify+req lonDegree<NEportLevels={2,0}> = 0.;
         double+read+notify+req lonMinute<NEportLevels={2,0}> = 0.;
         double+read+notify+req lonSecond<NEportLevels={2,0}> = 0.;
	 double+read+notify+req inAlt<NEportLevels={2,0}> = 0.;	
         double+write Latitude<NEportLevels={0,2}>;
         double+write Longitude<NEportLevels={0,2}>;
	 double+write Altitude<NEportLevels={0,2}>;
         cxxmethod+notify_inst createLL;
    };

    module GISProjection<cxx_class="Projection",
	cxx_hdr_files="fld/Xfld.h avs/gis/latlon.h avs/gis/transfrm.h",
	out_hdr_file="GISTrfm.hxx",
	out_src_file="GISTrfm.cxx",
	compile_src=0
	> {
         Data_Array+read+notify+req &inLLA<NEportLevels={2,0}> {
            nvals<NEportLevels={1,0}> = 1;
            veclen<NEportLevels={1,0}> = 3;
            values<NEportLevels={1,0}>;
         };
         Data_Array+write outXYZ<NEportLevels={0,2}> {
            nvals<NEportLevels={0,1}> => <-.inLLA.nvals;
            veclen<NEportLevels={0,1}> = 3;
            values<NEportLevels={0,1}>;
         };
         string+read+notify Transform<NEportLevels={2,2}> = "Globe";
         double+read+notify GlobalRadius<NEportLevels={2,2}> = 6378000.;
         double+read+notify baseLat<NEportLevels={2,2}> = 42.3486;
         double+read+notify baseLon<NEportLevels={2,2}> = -71.0036;
         double+read+notify firstPar<NEportLevels={2,2}> = 0;
         double+read+notify secondPar<NEportLevels={2,2}> = 0;
	 double+read+notify offsetLon<NEportLevels={2,2}> = 0.0;
         cxxmethod+notify_inst project<status=1>;
    };

    module GISInverseProj<cxx_class="Projection",
	cxx_hdr_files="fld/Xfld.h avs/gis/latlon.h avs/gis/transfrm.h",
	out_hdr_file="GISIntrf.hxx",
	out_src_file="GISIntrf.cxx",
	compile_src=0
	> {
         Data_Array+read+notify+req &inXYZ<NEportLevels={2,0}> {
            nvals<NEportLevels={1,0}> = 1;
            veclen<NEportLevels={1,0}> = 3;
            values<NEportLevels={1,0}>;
         };
         Data_Array+write outLLA<NEportLevels={0,2}> {
            nvals<NEportLevels={0,1}> => <-.inXYZ.nvals;
            veclen<NEportLevels={0,1}> => <-.inXYZ.veclen;
            values<NEportLevels={0,1}>;
         };
         string+read+notify InverseTransform<NEportLevels={2,2}> = "Globe";
         double+read+notify GlobalRadius<NEportLevels={2,2}> = 6378000.;
         double+read+notify baseLat<NEportLevels={2,2}> = 42.3486;
         double+read+notify baseLon<NEportLevels={2,2}> = 288.9964;
         double+read+notify firstPar<NEportLevels={2,2}> = 0.;
         double+read+notify secondPar<NEportLevels={2,2}> = 0.;
	 double+read+notify offsetLon<NEportLevels={2,2}> = 0.0;
         cxxmethod+notify_inst inv_project;
    };

    module GISGrid<cxx_hdr_files="fld/Xfld.h avs/gis/latlon.h",
	out_hdr_file="GISGrid.hxx",
	out_src_file="GISGrid.cxx",
	compile_src=0
	> {
         double+read+req westLongitude<NEportLevels={2,2}> = 185;
         double+read+req eastLongitude<NEportLevels={2,2}> = 315;
         double+read+req southLatitude<NEportLevels={2,2}> = 15;
         double+read+req northLatitude<NEportLevels={2,2}> = 85;
	 double+read+req meridianIncrement = 10.;
	 double+read+req parallelIncrement = 10.;
	 int+notify+req generate_data<NEportLevels={2,0}> = 0;
         Mesh outLLA<NEx=429.,NEy=11.,NEportLevels={0,2}> {
            Line cell_set[.ncell_sets];
         };
	 cxxmethod+notify_inst generateGrid;
    };

    group GISMeshProject {
         Mesh &in<NEportLevels={2,0}>;
         GISProjection project_coord {
            inLLA => <-.in.coordinates;
	    Transform<NEportLevels={3,3}>;
	    GlobalRadius<NEportLevels={3,3}>;
	    baseLat<NEportLevels={3,3}>;
	    baseLon<NEportLevels={3,3}>;
	    firstPar<NEportLevels={3,3}>;
	    secondPar<NEportLevels={3,3}>;
	    outXYZ {
		units = "meters";
	    };
         };
         group out_coord {
            Data_Array &coordinates => <-.project_coord.outXYZ;
         };
         Mesh &out<NEportLevels={0,2}> => merge(out_coord,in);
    };

    group GISMeshInvProject {
         Mesh &in<NEportLevels={2,0}>;
         GISInverseProj project_coord {
            inXYZ => <-.in.coordinates;
	    InverseTransform<NEportLevels={3,3}>;
	    GlobalRadius<NEportLevels={3,3}>;
	    baseLat<NEportLevels={3,3}>;
	    baseLon<NEportLevels={3,3}>;
	    firstPar<NEportLevels={3,3}>;
	    secondPar<NEportLevels={3,3}>;
	    outLLA {
		units = "Decimal Degrees";
	    };
         };
         group out_coord {
            Data_Array &coordinates => <-.project_coord.outLLA;
         };
         Mesh &out<NEportLevels={0,2}> => merge(out_coord,in);
    };

    macro GISLonConvert {
      	Mesh+read+req &in<NEportLevels={2,0}>;
      	long total_coords => .in.coordinates.nvals;
      	float x[] => .in.coordinates.values[0:.total_coords-1][0:0];
      	float y[] => .in.coordinates.values[0:.total_coords-1][1:1];
      	float z[] => .in.coordinates.values[0:.total_coords-1][2:2];

      	macro WesternHemisphere {
   	    float Longitudes[ArraySize][1] => <-.x;
   	    GMOD.copy_on_change coc {
      	        input[] => (<-.Zero < (<-.Longitudes - 180.));
      	        output<NEportLevels={0,3}>[][];
      	    };
            int ArraySize => <-.total_coords;
            float Zero[ArraySize][1] => init_array(ArraySize,0.0,0.0);
      	};

      	/* For each element in the x array, we must
           perform the following:
          	new_x = x - 360.0 * max(0, x-180) / max(x-180, 1e-10)
           We do this in V with the macro WesternHemisphere, which will
	   return an array of booleans: 1 if the long is in the western
	   hemisphere and 0 otherwise.
        */

      	float new_x[] => (x - 360.0 * WesternHemisphere.coc.output);

      	float coord[total_coords][3] => combine_array(new_x,y,z);
	
      	group out_info {
      	    Data_Array coordinates {
                veclen => <-.<-.in.coordinates.veclen;
                nvals => <-.<-.in.coordinates.nvals;
                values => <-.<-.coord;
            };
      	};
      	Mesh &out<NEportLevels={0,2}> => merge(out_info,in);
    };

};
