/*
                        Copyright (c) 1998 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/gis2.v#1 $
*/

#define PI 3.1415926526

flibrary+buffered+sort GIS_UI<NEeditable=1,libdeps="GIS GIS_UTIL GIS_MODS DV",
                              compile_subs=0,
                              disabled => Templates.CONFIG.gis_disabled,
                              needs_edit_lic="DV"> {

   macro GISWorldDataBank {
      UIpanel UIpanel {
         x = 10;
         y = 10;
         width<NEdisplayMode="open"> = 240;
         height = 470;
         parent => <-.UImod_panel;
      };
      VUIDial west_longitude{
        parent => <-.UIpanel;
        height = 150;
        value = 185.;
        title = "Western Long";
        y = 155;
        width = 95;
        float min = -180.;
        float max = 359.9999;
        decimalPoints = 1;
        Dial {
             height = 120;
        };
      };
      VUIDial east_longitude{
        parent => <-.UIpanel;
        height = 150;
        value = 315.;
        title = "Eastern Long";
        x = 100;
        y = 155;
        width = 95;
        float min = -180.;
        float max = 359.9999;
        decimalPoints = 1;
        Dial {
             height = 120;
        };
      };
      VUIDial south_latitude{
        parent => <-.UIpanel;
        height = 150;
        value = 15.;
        title = "Southern Lat";
        y = 310;
        width = 95;
        min = -90;
        max = 90;
        decimalPoints = 1;
        Dial {
             height = 120;
        };
       };
       VUIDial north_latitude {
         parent => <-.UIpanel;
         height = 150;
         value = 85.;
         title = "Northern Lat";
         x = 100;
         y = 310;
         width = 95;
         min = -90;
         max = 90;
         decimalPoints = 1;
         Dial {
            height = 120;
         };
      };

      UIpanel UIpanel#1 {
         x = 10;
         y = 480;
         width = 250;
         height = 480;
         clientHeight = 480;
         parent => <-.UImod_panel;
      };

      VUIList geographic {
            parent => <-.UIpanel#1;
             ListFrame {
             clientWidth = 196;
                 clientHeight = 96;
              };
              List {
                 selectedItem = 1;
              };
              label = "Geographic Data";
              selectedText<NEportLevels={0,2}> = "None";
              strings = {"All","None",
                         "Definite","Indefinite"};
      };
      VUIList political {
              parent => <-.UIpanel#1;
              y = 100;
              label = "Political Data";
              selectedText<NEportLevels={0,2}> = "None";
              strings = {"All","None",
                         "Definite","Indefinite"};
              ListFrame<NEx=242.,NEy=209.> {
                 clientWidth = 196;
                 clientHeight = 96;
              };
              List {
                 selectedItem = 1;
              };
      };
      VUIList coastal {
              parent => <-.UIpanel#1;
              y = 200;
              label = "Coastal Data";
              selectedText<NEportLevels={0,2}> = "All";
              strings = {"All","None",
                         "Minor","Major",
                         "Minor Some Maps","Major Some Maps",
                         "Reefs","Ocean Salt Pans",
                         "Glaciers","Continental Shelves"
              };
              ListFrame {
                 clientWidth = 196;
                 clientHeight = 96;
              };
              List {
                 selectedItem = 0;
              };
      };
      VUIList rivers {
              parent => <-.UIpanel#1;
              y = 300;
              label = "River and Irrigation Data";
              selectedText<NEportLevels={0,2}> = "None";
              strings = {"All","None",
                         "Minor","Major",
                         "Minor Some Maps","Major Some Maps",
                         "Additional Major","Minor Canals",
                         "Major Canals","Recorded Irrigation",
                         "Double Lined Beds"
              };
              ListFrame {
                 clientWidth = 196;
                 clientHeight = 96;
              };
              List {
                 selectedItem = 1;
              };
      };
      UIbutton ingest {
         y = 10;
         width = 200;
         height = 25;
         parent => UIpanel;
         label => "READ AND FILTER MAPS";
      };

      GIS_READERS.GISCIAMapII GISCIAMapII {
         ciaDirectory => <-.cia_directory.text;
         precision => <-.precision.value;
         westLongitude => <-.west_longitude.value;
         eastLongitude => <-.east_longitude.value;
         southLatitude => <-.south_latitude.value;
         northLatitude => <-.north_latitude.value;
         geographicFeatures => <-.geographic.selectedText;
         politicalFeatures => <-.political.selectedText;
         coastalFeatures => <-.coastal.selectedText;
         riverFeatures => <-.rivers.selectedText;
         read_data => <-.ingest.do;
         geoPolylines<NEportLevels={0,3}>;
         polPolylines<NEportLevels={0,3}>;
         coastalPolylines<NEportLevels={0,3}>;
         riverPolylines<NEportLevels={0,3}>;
      };
      UImod_panel UImod_panel {
         x = 0;
         y = 0;
         width = 230;
         option {
            set = 0;
            do = 1;
         };
         title => name_of(<-.<-);
      };
      UIslider precision {
         parent => <-.UIpanel;
         height = 60;
         value = 3600.;
         y = 85;
         min = 1.;
         max = 7200.;
         decimalPoints = 0;
      };
      UItext cia_directory {
         parent => <-.UIpanel;
         text = "$XP_PATH<0>/data/Maps";
         y = 50;
         width = 200;
      };
      macro Greater {
         double A<NEportLevels={2,1}> => <-.west_longitude.value;
         double B<NEportLevels={2,1}> => <-.east_longitude.value;
         int Result<NEportLevels={1,2}> => .coc.output;
         GMOD.copy_on_change coc {
            input => (<-.A > <-.B);
            output = 0;
         };
      };
      UIerrorDialog LongError {
         visible => <-.Greater.Result;
         title => "Longitude Error";
         message = "The Western Longitude cannot be greater than\nthe Eastern Longitude. Keep in mind\nthat the 0 degree meridian\nruns through Greenwich, England.\nAll longitudes increase as we\nproceed east of Greenwich.";
         ok = 1;
      };
      UIerrorDialog LatError{
         visible => <-.Greater#1.Result;
         message = "The Southern Latitude cannot be greater than\nthe Northern Latitude. Keep in mind that the 0 degree\nparallel is the equator. Latitudes increase as we proceed north from\nthe equator and decrease as we proceed south\nfrom the equator.";
         title => "Latitude Error";
         ok = 1;
      };
      macro Greater#1 {
         double A<NEportLevels={2,1}> => <-.south_latitude.value;
         double B<NEportLevels={2,1}> => <-.north_latitude.value;
         int Result<NEportLevels={1,2}> => .coc.output;
         GMOD.copy_on_change coc {
            input => (<-.A > <-.B);
            output = 0;
         };
      };

   };

   macro GISMapTransform{
      UIpanel UIpanel {
         x = 6;
         y = 10;
         width = 240;
         height = 800;
         parent => <-.UImod_panel;
      };
   VUIList Transform{
      parent => UIpanel;
      y = 10;
      label = "Select Map Transform:";
      selectedText<NEportLevels={0,2}> = "Globe";
      strings = {
         "Globe","Mercator","Cartesian","Lambert Cylindrical",
         "Lambert Conic Conformal","Gnomonic","Stereographic","Orthographic",
         "Postel","Lambert Azimuthal","Albers","Cassini-Soldner","Bonne","Werner",
         "Sanson-Flamsteed"
      };
      ListFrame {
         clientWidth = 196;
         clientHeight = 96;
      };
      List {
         selectedItem = 0;
      };
   };
   VUIDial BaseLat {
      parent => <-.UIpanel;
      height = 150;
      Field;
      Up;
      Down;
      ParseDown;
      value<NEportLevels={0,2}> = 42.3486;
      title = "Latitude";
      x;
      y = 150;
      width = 100;
      min = -90;
      max = 90;
      decimalPoints = 2;
      immediate ;
      visible;
      Dial {
         height => 120;
      };
      ParseUp;
   };
   VUIDial BaseLon{
      parent => <-.UIpanel;
      height = 150;
      Field;
      Up;
      Down;
      ParseDown;
      value<NEportLevels={0,2}> = 288.9964;
      title = "Longitude";
      x  = 100;
      y<NEx=305.,NEy=28.> = 150;
      width<NEx=455.,NEy=28.> = 100;
      min<NEx=455.,NEy=112.> = -180;
      max<NEx=605.,NEy=112.> = 360;
      decimalPoints<NEx=12.,NEy=196.> = 2;
      immediate<NEx=155.,NEy=112.>;
      visible<NEx=5.,NEy=112.>;
      Dial<NEx=44.,NEy=154.> {
         height => 120;
      };
      ParseUp<NEx=286.,NEy=264.>;
   };

   VUIDial FirstParallel<NEx=33.,NEy=264.,NExOffset=90.,NEyOffset=50.> {
      parent<NEx=5.,NEy=28.> => <-.UIpanel;
      height<NEx=605.,NEy=28.> = 150;
      Field<NEx=261.,NEy=364.>;
      Up<NEx=342.,NEy=196.>;
      Down<NEx=507.,NEy=196.>;
      ParseDown<NEx=480.,NEy=280.>;
      value<NEportLevels={0,2}> = 0.;
      title<NEx=177.,NEy=196.> = "First";
      x<NEx=155.,NEy=28.>;
      y<NEx=305.,NEy=28.> = 340;
      width<NEx=455.,NEy=28.> = 100;
      min<NEx=455.,NEy=112.> = -90;
      max<NEx=605.,NEy=112.> = 90;
      decimalPoints<NEx=12.,NEy=196.> = 2;
      immediate<NEx=155.,NEy=112.>;
      visible<NEx=5.,NEy=112.>;
      Dial<NEx=44.,NEy=154.> {
         height => 120;
      };
      ParseUp<NEx=286.,NEy=264.>;
   };
   VUIDial SecondParallel<NEx=198.,NEy=264.,NExOffset=93.74274445,NEyOffset=52.16788101> {
      parent<NEx=5.,NEy=28.> => <-.UIpanel;
      height<NEx=605.,NEy=28.> = 150;
      Field<NEx=261.,NEy=364.>;
      Up<NEx=342.,NEy=196.>;
      Down<NEx=507.,NEy=196.>;
      ParseDown<NEx=480.,NEy=280.>;
      value<NEportLevels={0,2}> = 0.;
      title<NEx=177.,NEy=196.> = "Second";
      x<NEx=155.,NEy=28.> = 100;
      y<NEx=305.,NEy=28.> = 340;
      width<NEx=455.,NEy=28.> = 100;
      min<NEx=455.,NEy=112.> = -90;
      max<NEx=605.,NEy=112.> = 90;
      decimalPoints<NEx=12.,NEy=196.> = 2;
      immediate<NEx=155.,NEy=112.>;
      visible<NEx=5.,NEy=112.>;
      Dial<NEx=44.,NEy=154.> {
         height => 120;
      };
      ParseUp<NEx=286.,NEy=264.>;
   };

   VUIDial Radius {
      parent<NEx=5.,NEy=28.> => <-.UIpanel;
      height<NEx=605.,NEy=28.> = 150;
      Field<NEx=261.,NEy=364.>;
      Up<NEx=342.,NEy=196.>;
      Down<NEx=507.,NEy=196.>;
      ParseDown<NEx=480.,NEy=280.>;
      value<NEportLevels={0,2}> = 6378000.;
      title<NEx=177.,NEy=196.> = "Global Radius";
      x<NEx=155.,NEy=28.>;
      y<NEx=305.,NEy=28.> = 530;
      width<NEx=455.,NEy=28.> = 100;
      min<NEx=455.,NEy=112.> = 0;
      max<NEx=605.,NEy=112.> = 10000000;
      decimalPoints<NEx=12.,NEy=196.> = 0;
      immediate<NEx=155.,NEy=112.>;
      visible<NEx=5.,NEy=112.>;
      Dial<NEx=44.,NEy=154.> {
         height => 120;
      };
      ParseUp<NEx=286.,NEy=264.>;
   };

   VUIDial Offset {
      parent<NEx=5.,NEy=28.> => <-.UIpanel;
      height<NEx=605.,NEy=28.> = 150;
      Field<NEx=261.,NEy=364.>;
      Up<NEx=342.,NEy=196.>;
      Down<NEx=507.,NEy=196.>;
      ParseDown<NEx=480.,NEy=280.>;
      value<NEportLevels={0,2}> = 0.;
      title<NEx=177.,NEy=196.> = "Longitude Offset";
      x<NEx=155.,NEy=28.> = 100;
      y<NEx=305.,NEy=28.> = 530;
      width<NEx=455.,NEy=28.> = 100;
      min<NEx=455.,NEy=112.> = -180.;
      max<NEx=605.,NEy=112.> = 360.;
      decimalPoints<NEx=12.,NEy=196.> = 2;
      immediate<NEx=155.,NEy=112.>;
      visible<NEx=5.,NEy=112.>;
      Dial<NEx=44.,NEy=154.> {
         height => 120;
      };
      ParseUp<NEx=286.,NEy=264.>;
   };

      UIlabel UIlabel#1 {
         y = 130;
         width = 150;
         height => 16;
         parent => <-.UIpanel;
         label<NEdisplayMode="open"> => "Center of Projection:";
      };
      UIlabel UIlabel#2 {
         y = 320;
         width = 190;
         height => 16;
         parent => <-.UIpanel;
         label => "Conic Projection Parallels:";
      };
      UIlabel UIlabel#3 {
         y = 510;
         width = 190;
         height => 16;
         parent => <-.UIpanel;
         label => "Miscellany:";
      };
      GIS.GISMeshProject GISMeshProject<NEx=2.,NEy=323.> {
         in<NEportLevels={3,0}>;
         project_coord<NEdisplayMode="open"> {
            Transform<NEportLevels={3,3}> => <-.<-.Transform.selectedText;
            GlobalRadius<NEportLevels={3,3}> => <-.<-.Radius.value;
            baseLat<NEportLevels={3,3}> => <-.<-.BaseLat.value;
            baseLon<NEportLevels={3,3}> => <-.<-.BaseLon.value;
            firstPar<NEportLevels={3,3}> => <-.<-.FirstParallel.value;
            secondPar<NEportLevels={3,3}> => <-.<-.SecondParallel.value;
            offsetLon<NEportLevels={3,3}> => <-.<-.Offset.value;
         };
         out<NEportLevels={0,3}>;
      };
      GDM.DataObject MapObject {
         in => <-.GISMeshProject.out;
         Props {
             inherit = 0;
             col = {1., 1., 1.};
         };
         obj<NEportLevels={0,3}>;
      };
      GIS.GISMeshProject GISMeshProject#2<NEx=167.,NEy=323.> {
         in<NEportLevels={3,0}>;
         project_coord<NEdisplayMode="open"> {
            Transform => <-.<-.Transform.selectedText;
            GlobalRadius => <-.<-.Radius.value;
            baseLat => <-.<-.BaseLat.value;
            baseLon => <-.<-.BaseLon.value;
            firstPar => <-.<-.FirstParallel.value;
            secondPar => <-.<-.SecondParallel.value;
            offsetLon<NEportLevels={3,3}> => <-.<-.Offset.value;
         };
         out<NEportLevels={0,3}>;
      };
      GDM.DataObject MapObject#2 {
         in => <-.GISMeshProject#2.out;
         Props {
            inherit = 0;
            col = {1., 0., 0.};
         };
         obj<NEportLevels={0,3}>;
      };
      GIS.GISMeshProject GISMeshProject#3<NEx=332.,NEy=323.> {
         in<NEportLevels={3,0}>;
         project_coord<NEdisplayMode="open"> {
            Transform => <-.<-.Transform.selectedText;
            GlobalRadius => <-.<-.Radius.value;
            baseLat => <-.<-.BaseLat.value;
            baseLon => <-.<-.BaseLon.value;
            firstPar => <-.<-.FirstParallel.value;
            secondPar => <-.<-.SecondParallel.value;
            offsetLon<NEportLevels={3,3}> => <-.<-.Offset.value;
         };
         out<NEportLevels={0,3}>;
      };
      GDM.DataObject MapObject#3 {
         in => <-.GISMeshProject#3.out;
         Props {
            inherit = 0;
            col = {0., 1., 0.};
         };
         obj<NEportLevels={0,3}>;
      };
      GIS.GISMeshProject GISMeshProject#4<NEx=497.,NEy=323.> {
         in<NEportLevels={3,0}>;
         project_coord<NEdisplayMode="open"> {
            Transform => <-.<-.Transform.selectedText;
            GlobalRadius => <-.<-.Radius.value;
            baseLat => <-.<-.BaseLat.value;
            baseLon => <-.<-.BaseLon.value;
            firstPar => <-.<-.FirstParallel.value;
            secondPar => <-.<-.SecondParallel.value;
            offsetLon<NEportLevels={3,3}> => <-.<-.Offset.value;
         };
         out<NEportLevels={0,3}>;
      };
      GDM.DataObject MapObject#4 {
         in => <-.GISMeshProject#4.out;
         Props {
            inherit = 0;
            col = {0., 0., 1.};
         };
         obj<NEportLevels={0,3}>;
      };
      UImod_panel UImod_panel {
         option {
            set = 0;
            do = 2;
         };
         title => name_of(<-.<-);
         width = 260;

      };
   };

   macro GISGridGenerate<NEx=165.,NEy=22.> {
      UIpanel UIpanel {
         x = 20;
         y = 0;
         width = 270;
         height = 600;
         parent => <-.UImod_panel;
      };

      VUIDial MinMer {
         x = 20;
         y = 50;
         width = 100;
         height = 150;
         parent => UIpanel;
         min = -180.;
         max = 360.;
         value<NEportLevels={2,2}> = 185.;
         title => "Min Meridian";
         Field<NEx=261.,NEy=364.>;
         Up<NEx=342.,NEy=196.>;
         Down<NEx=507.,NEy=196.>;
         ParseDown<NEx=480.,NEy=280.>;
         decimalPoints<NEx=12.,NEy=196.> = 2;
         immediate<NEx=155.,NEy=112.>;
         visible<NEx=5.,NEy=112.>;
         Dial<NEx=44.,NEy=154.> {
                height => 120;
         };
         ParseUp<NEx=286.,NEy=264.>;
      };

      VUIDial MaxMer {
         x = 120;
         y = 50;
         width = 100;
         height = 150;
         parent => UIpanel;
         min = -180.;
         max = 360.;
         value<NEportLevels={2,2}> = 315.;
         title => "Max Meridian";
         Field<NEx=261.,NEy=364.>;
         Up<NEx=342.,NEy=196.>;
         Down<NEx=507.,NEy=196.>;
         ParseDown<NEx=480.,NEy=280.>;
         decimalPoints<NEx=12.,NEy=196.> = 2;
         immediate<NEx=155.,NEy=112.>;
         visible<NEx=5.,NEy=112.>;
         Dial<NEx=44.,NEy=154.> {
                height => 120;
         };
         ParseUp<NEx=286.,NEy=264.>;
      };

      VUIDial MinPar {
         x = 20;
         y = 200;
         width = 100;
         height = 150;
         parent => UIpanel;
         min = -90.;
         max = 90.;
         value<NEportLevels={2,2}> = 15.;
         title => "Min Parallel";
         Field<NEx=261.,NEy=364.>;
         Up<NEx=342.,NEy=196.>;
         Down<NEx=507.,NEy=196.>;
         ParseDown<NEx=480.,NEy=280.>;
         decimalPoints<NEx=12.,NEy=196.> = 2;
         immediate<NEx=155.,NEy=112.>;
         visible<NEx=5.,NEy=112.>;
         Dial<NEx=44.,NEy=154.> {
                height => 120;
         };
         ParseUp<NEx=286.,NEy=264.>;
      };


      VUIDial MaxPar {
         x = 120;
         y = 200;
         width = 100;
         height = 150;
         parent => UIpanel;
         min = -90.;
         max = 90.;
         value<NEportLevels={2,2}> = 85.;
         title => "Max Parallel";
         Field<NEx=261.,NEy=364.>;
         Up<NEx=342.,NEy=196.>;
         Down<NEx=507.,NEy=196.>;
         ParseDown<NEx=480.,NEy=280.>;
         decimalPoints<NEx=12.,NEy=196.> = 2;
         immediate<NEx=155.,NEy=112.>;
         visible<NEx=5.,NEy=112.>;
         Dial<NEx=44.,NEy=154.> {
                height => 120;
         };
         ParseUp<NEx=286.,NEy=264.>;
      };

      UIslider UIslider {
         x = 20;
         y = 380;
         parent => UIpanel;
         min = 1.;
         max = 3600.;
         value<NEportLevels={2,2}> = 10.;
         decimalPoints = 0;
         title => "Meridian Increment";
         double increment = 5.;
      };
      UIslider UIslider#1 {
         x = 20;
         y = 460;
         parent => UIpanel;
         min = 1.;
         max = 1800.;
         value<NEportLevels={2,2}> = 10.;
         decimalPoints = 0;
         title => "Parallel Increment";
         increment = 5.;
      };
      UIbutton UIbutton {
         x = 40;
         y = 10;
         width = 170;
         parent => UIpanel;
         label => "Generate Grid";
         do = 2;
      };
      GIS.GISGrid GISGrid {
         westLongitude => <-.MinMer.value;
         eastLongitude => <-.MaxMer.value;
         southLatitude => <-.MinPar.value;
         northLatitude => <-.MaxPar.value;
         meridianIncrement<NEportLevels={2,0}> => <-.UIslider.value;
         parallelIncrement<NEportLevels={2,0}> => <-.UIslider#1.value;
         generate_data => <-.UIbutton.do;
         outLLA<NEportLevels={0,3}>;
      };
      UImod_panel UImod_panel {
         option {
            set = 0;
            do = 1;
         };
         title => name_of(<-.<-);
         clientWidth = 200;
         x = -20;
         width = 1500;
      };
      macro Greater<NEx=317.,NEy=398.,NEwidth=165.,NEheight=132.> {
         double A<NEportLevels={2,1}> => <-.MinMer.value;
         double B<NEportLevels={2,1}> => <-.MaxMer.value;
         int Result<NEportLevels={1,2}> => .coc.output;
         GMOD.copy_on_change coc {
            input => (<-.A > <-.B);
            output = 0;
         };
      };
      UIerrorDialog LongError<NEx=123.,NEy=473.> {
         visible => <-.Greater.Result;
         title => "Longitude Error";
         message = "The Minimum Meridian cannot be greater than\nthe Maximum Meridian. Keep in mind\nthat the 0 degree meridian\nruns through Greenwich, England.\nAll longitudes increase as we\nproceed east of Greenwich.";
         ok = 1;
      };
      UIerrorDialog LatError<NEx=510.,NEy=473.> {
         visible => <-.Greater#1.Result;
         message = "The Minimum Parallel cannot be greater than\nthe Maximum Parallel. Keep in mind that the 0 degree\nparallel is the equator. Latitudes increase as we proceed north from\nthe equator and decrease as we proceed south\nfrom the equator.";
         title => "Latitude Error";
         ok = 1;
      };
      macro Greater#1<NEx=575.,NEy=398.,NEwidth=165.,NEheight=132.> {
         double A<NEportLevels={2,1}> => <-.MinPar.value;
         double B<NEportLevels={2,1}> => <-.MaxPar.value;
         int Result<NEportLevels={1,2}> => .coc.output;
         GMOD.copy_on_change coc {
            input => (<-.A > <-.B);
            output = 0;
         };
      };

   };


   macro GISDigitalElevation<NEx=176.,NEy=77.> {
     UIerrorDialog FileError {
       title => "Digital Elevation Map Read Error";
       message => ((("You have just tried reading file\n" + .fname) + "\n\nThis file is either not present, corrupted or is\nnot a USGS Digital Elevation Map file.\nPlease check the file and try again.\n\nPlease note: values in the 'QuadName' and\n'Information' fields are now invalid.\n\nResponse from DEM Reader:\n") + retResponse);
       ok = 1;
       string fname<NEportLevels={2,0}> => <-.UIfileDialog.filename;
       string retResponse<NEportLevels={2,0}> => <-.GISDEM.status;
       visible => <-.IsNotEqual.Result;
     };

     macro IsNotEqual<NEwidth=165.,NEheight=132.> {
       int Result<NEportLevels={1,2},NEx=451.,NEy=253.> => .coc.output;
       GMOD.copy_on_change coc<NEx=418.,NEy=165.> {
          input => <-.Compare;
          on_inst<NEdisplayMode="open">;
       };
       string B<NEportLevels=1,NEx=385.,NEy=33.> = "File is ok";
       string A<NEportLevels={2,1},NEx=352.,NEy=77.> => <-.GISDEM.status;
       int Compare<NEx=165.,NEy=154.,NEportLevels={0,1}> => (strcmp(.A,.B) != 0);
     };

      UImod_panel UImod_panel {
         x = -20;
         clientWidth = 200;
         title => name_of(<-.<-);
         option {
            do = 2;
            set = 0;
         };
      }; 
      UIpanel UIpanel {
         x = 30;
         y = 0;
         width = 230;
         height = 400;
         parent => <-.UImod_panel;
      };
      UIbutton NewFile {
         x = 20;
         y = 50;
         width = 150;
         parent => <-.UIpanel;
         label => "Get New DEM File";
      };
      UIslider Subsample {
         x = 20;
         y = 90;
         parent => <-.UIpanel;
         min = 0.;
         max = 1.;
         value<NEportLevels={2,2}> = 0.05;
         decimalPoints = 3;
         title => "Subsample";
         double increment = 0.025;
         width = 150;
	 height = 60;
      };
      UIfileDialog UIfileDialog {
         visible => <-.NewFile.do;
	 searchPattern = "*";
      };
      GIS_READERS.GISDEM GISDEM {
         demFile => <-.UIfileDialog.filename;
         GlobalRadius => <-.Radius.value;
         read_data => <-.Ingest.do;
         subsample<NEportLevels={2,0}> => <-.Subsample.value;
         QuadName<NEportLevels={0,2}>;
         Information<NEportLevels={0,2}>;
         demGrid<NEportLevels={0,3}>;
      };
      UIslider Radius {
         x = 20;
         y = 150;
         width = 150;
         height = 60;
         parent => <-.UIpanel;
         min = 1.;
         max = 10000000.;
         value<NEportLevels={2,2}> = 6378000.;
         decimalPoints = 0;
         title => "Radius (m)";
         increment = 1000.;
      };
      UIbutton Ingest {
         x = 20;
         y = 5;
         width = 150;
         height = 20;
         parent => <-.UIpanel;
         label => "Read and Subsample";
      };
      UIlabel QuadLabel {
         parent => <-.UIpanel;
         label => "USGS Quad Name:";
         x = 10;
         y = 245;
         width = 150;
      };
      UItext QuadName {
         parent => <-.UIpanel;
         text<NEportLevels={2,0}> => <-.GISDEM.QuadName;
         x = 5;
         y = 270;
         width = 205;
      };
      UIlabel InfoLabel {
         parent => <-.UIpanel;
         label => "USGS Additional Info:";
         x = 10;
         y = 325;
         width = 150;
      };
      UItext Information {
         parent => <-.UIpanel;
         text<NEportLevels={2,0}> => <-.GISDEM.Information;
         x = 5;
         y = 350;
         width = 205;
      };
   };

   macro GISGeneratePlanet {
     float Earth_Radius<NEportLevels={2,0}> = 6378000.;
     Field_Spher_Unif sphere<NEportLevels={0,1}> {
       nspace = 3;
       ndim = 3;
       nnode_data = 1;
       node_data{
         veclen = 1;
       } = {
         {
         values=>1,,,,,,,
         }};
       dims = {2,64,32};
       points => {1,0,0,(<-.Earth_Radius - (<-.Earth_Radius * 0.01)), PI, (2 * PI) };
       cell_set;
     };

     DV.DVbounds DVbounds {
       DV_Param_bounds &param<NEportLevels={2,0}> {
         hull = 0;
         edges = 0;
         faces = 1;
         imin = 0;
         imax = 1;
         jmin = 0;
         jmax = 0;
         kmin = 0;
         kmax = 0;
         data = 0;
         component = 0;
       };
       in => <-.sphere;
       hull<NEportLevels={1,0}> => param.hull;
       edges<NEportLevels={1,0}> => param.edges;
       faces<NEportLevels={1,0}> => param.faces;
       imin<NEportLevels={1,0}> => param.imin;
       imax<NEportLevels={1,0}> => param.imax;
       jmin<NEportLevels={1,0}> => param.jmin;
       jmax<NEportLevels={1,0}> => param.jmax;
       kmin<NEportLevels={1,0}> => param.kmin;
       kmax<NEportLevels={1,0}> => param.kmax;
       data<NEportLevels={1,0}> => param.data;
      component<NEportLevels={1,0}> => param.component;
     };

     
     GDM.DataObject SphereObject {
       in => <-.DVbounds.out;
       Props<NEx=264.,NEy=143.> {
         inherit = 0;
         col => {<-.<-.red.value,
                 <-.<-.green.value,
                 <-.<-.blue.value};
       };

       MinMax {
         min_value = 1.;
       };
       Datamap {
         ranges;
         DataRange;
         colorModel;
         ColorModels;
         currentColorModel = 1;
         RGBcolorModel;
       };
       Modes {
         mode => {
            0,0,<-.<-.Surface,0,0
         };
       };
       Texture;
       AltObject;
       obj<NEportLevels={1,3}>;
     };
     UIpanel UIpanel {
       x = 20;
       y = 0;
       width = 270;
       height = 600;
       parent => <-.UImod_panel;
     };
     UImod_panel UImod_panel {
       option {
         set = 1;
         do = 1;
       };
       title => "GISGeneratePlanet";
       clientWidth = 1500;
       x = -20;
       width = 1500;
     };
     UItoggle Invisible {
       parent => <-.UIpanel;
       label => "Invisible Planet";
       do<NEportLevels={0,1}>;
       y = 0;
     };
     UIslider red {
       parent => <-.UIpanel;
       value<NEportLevels={2,2}> = 0.5;
       x = 30;
       y = 30;
       min = 0.;
       max = 1.;
     };
     UIslider green {
       parent => <-.UIpanel;
       value<NEportLevels={2,2}> = 0.8;
       x = 30;
       y = 80;
       min = 0.;
       max = 1.;
     };
     UIslider blue {
       parent => <-.UIpanel;
       value<NEportLevels={2,2}> = 1.0;
       x = 30;
       y = 130;
       min = 0.;
       max = 1.;
     };

     int Surface<NEportLevels={1,0}> => switch((Invisible.set + 1),4,5);
   };

   macro GISMapInvTransform<NEx=308.,NEy=165.> {
     UIpanel UIpanel<NEx=346.,NEy=143.> {
       x = 6;
       y = 10;
       width = 240;
       height = 800;
       parent => <-.UImod_panel;
     };
     VUIList Transform<NEx=13.,NEy=248.> {
       parent => <-.UIpanel;
       y = 10;
       label = "Select Map Transform:";
       selectedText<NEportLevels={0,2}> = "Globe";
       strings<NEx=1111.,NEy=77.,NEwidth=220.,NEheight=242.> = {
         "Globe","Mercator","Cartesian","Lambert Cylindrical",
         "Lambert Conic Conformal","Stereographic","Orthographic",
         "Lambert Azimuthal","Albers"
       };
       ListFrame<NEx=242.,NEy=209.> {
         clientWidth = 196;
         clientHeight = 96;
       };
       List {
         selectedItem = 0;
       };
     };
     VUIDial BaseLat<NEx=179.,NEy=248.> {
       parent => <-.UIpanel;
       x<NEx=155.,NEy=28.>;
       y<NEx=305.,NEy=28.> = 150;
       width<NEx=455.,NEy=28.> = 100;
       height<NEx=605.,NEy=28.> = 150;
       visible<NEx=5.,NEy=112.>;
       immediate<NEx=155.,NEy=112.>;
       value<NEportLevels={0,2}> = 42.3486;
       min<NEx=455.,NEy=112.> = -90;
       max<NEx=605.,NEy=112.> = 90;
       decimalPoints<NEx=12.,NEy=196.> = 2;
       title<NEx=177.,NEy=196.> = "Latitude";
       Dial<NEx=44.,NEy=154.> {
         height => 120;
       };
       Field<NEx=261.,NEy=364.>;
       Up<NEx=342.,NEy=196.>;
       Down<NEx=507.,NEy=196.>;
       ParseUp<NEx=286.,NEy=264.>;
       ParseDown<NEx=480.,NEy=280.>;
     };
     VUIDial BaseLon<NEx=345.,NEy=248.> {
       parent => <-.UIpanel;
       x<NEx=155.,NEy=28.> = 100;
       y<NEx=305.,NEy=28.> = 150;
       width<NEx=455.,NEy=28.> = 100;
       height<NEx=605.,NEy=28.> = 150;
       visible<NEx=5.,NEy=112.>;
       immediate<NEx=155.,NEy=112.>;
       value<NEportLevels={0,2}> = 288.9964;
       min<NEx=455.,NEy=112.> = -180;
       max<NEx=605.,NEy=112.> = 360;
       decimalPoints<NEx=12.,NEy=196.> = 2;
       title<NEx=177.,NEy=196.> = "Longitude";
       Dial<NEx=44.,NEy=154.> {
         height => 120;
       };
       Field<NEx=261.,NEy=364.>;
       Up<NEx=342.,NEy=196.>;
       Down<NEx=507.,NEy=196.>;
       ParseUp<NEx=286.,NEy=264.>;
       ParseDown<NEx=480.,NEy=280.>;
     };
     VUIDial FirstParallel<NEx=511.,NEy=248.,NExOffset=90.0,NEyOffset=50.0> {
       parent<NEx=5.,NEy=28.> => <-.UIpanel;
       x<NEx=155.,NEy=28.>;
       y<NEx=305.,NEy=28.> = 340;
       width<NEx=455.,NEy=28.> = 100;
       height<NEx=605.,NEy=28.> = 150;
       visible<NEx=5.,NEy=112.>;
       immediate<NEx=155.,NEy=112.>;
       value<NEportLevels={0,2}> = 0.;
       min<NEx=455.,NEy=112.> = -90;
       max<NEx=605.,NEy=112.> = 90;
       decimalPoints<NEx=12.,NEy=196.> = 2;
       title<NEx=177.,NEy=196.> = "First";
       Dial<NEx=44.,NEy=154.> {
         height => 120;
       };
       Field<NEx=261.,NEy=364.>;
       Up<NEx=342.,NEy=196.>;
       Down<NEx=507.,NEy=196.>;
       ParseUp<NEx=286.,NEy=264.>;
       ParseDown<NEx=480.,NEy=280.>;
     };
     VUIDial SecondParallel<NEx=677.,NEy=248.,NExOffset=90.,NEyOffset=50.> {
       parent<NEx=5.,NEy=28.> => <-.UIpanel;
       x<NEx=155.,NEy=28.> = 100;
       y<NEx=305.,NEy=28.> = 340;
       width<NEx=455.,NEy=28.> = 100;
       height<NEx=605.,NEy=28.> = 150;
       visible<NEx=5.,NEy=112.>;
       immediate<NEx=155.,NEy=112.>;
       value<NEportLevels={0,2}> = 0.;
       min<NEx=455.,NEy=112.> = -90;
       max<NEx=605.,NEy=112.> = 90;
       decimalPoints<NEx=12.,NEy=196.> = 2;
       title<NEx=177.,NEy=196.> = "Second";
       Dial<NEx=44.,NEy=154.> {
         height => 120;
       };
       Field<NEx=261.,NEy=364.>;
       Up<NEx=342.,NEy=196.>;
       Down<NEx=507.,NEy=196.>;
       ParseUp<NEx=286.,NEy=264.>;
       ParseDown<NEx=480.,NEy=280.>;
     };
     VUIDial Radius<NEx=34.,NEy=353.> {
       parent<NEx=5.,NEy=28.> => <-.UIpanel;
       x<NEx=155.,NEy=28.>;
       y<NEx=305.,NEy=28.> = 530;
       width<NEx=455.,NEy=28.> = 100;
       height<NEx=605.,NEy=28.> = 150;
       visible<NEx=5.,NEy=112.>;
       immediate<NEx=155.,NEy=112.>;
       value<NEportLevels={0,2}> = 6378000.;
       min<NEx=455.,NEy=112.> = 0;
       max<NEx=605.,NEy=112.> = 10000000;
       decimalPoints<NEx=12.,NEy=196.> = 0;
       title<NEx=177.,NEy=196.> = "Global Radius";
       Dial<NEx=44.,NEy=154.> {
         height => 120;
       };
       Field<NEx=261.,NEy=364.>;
       Up<NEx=342.,NEy=196.>;
       Down<NEx=507.,NEy=196.>;
       ParseUp<NEx=286.,NEy=264.>;
       ParseDown<NEx=480.,NEy=280.>;
     };
     UIlabel UIlabel#1<NEx=242.,NEy=353.> {
       y = 130;
       width = 150;
       height => 16;
       parent => <-.UIpanel;
       label<NEdisplayMode="open"> => "Center of Projection:";
     };
     UIlabel UIlabel#2<NEx=450.,NEy=353.> {
       y = 320;
       width = 190;
       height => 16;
       parent => <-.UIpanel;
       label => "Conic Projection Parallels:";
     };
     UIlabel UIlabel#3<NEx=658.,NEy=353.> {
       y = 510;
       width = 190;
       height => 16;
       parent => <-.UIpanel;
       label => "Miscellany:";
     };
     UImod_panel UImod_panel<NEx=346.,NEy=38.> {
       width = 260;
       title => name_of(<-.<-);
       option {
         do = 2;
         set = 1;
       };
     };
     GIS.GISMeshInvProject GISMeshInvProject<NEx=24.,NEy=458.> {
       in<NEportLevels={3,0}>;
       project_coord {
         InverseTransform => <-.<-.Transform.selectedText;
         GlobalRadius => <-.<-.Radius.value;
         baseLat => <-.<-.BaseLat.value;
         baseLon => <-.<-.BaseLon.value;
         firstPar => <-.<-.FirstParallel.value;
         secondPar => <-.<-.SecondParallel.value;
       };
       out<NEportLevels={0,3}>;
     };
     GIS.GISMeshInvProject GISMeshInvProject#2<NEx=232.,NEy=458.> {
       in<NEportLevels={3,0}>;
       project_coord {
         InverseTransform => <-.<-.Transform.selectedText;
         GlobalRadius => <-.<-.Radius.value;
         baseLat => <-.<-.BaseLat.value;
         baseLon => <-.<-.BaseLon.value;
         firstPar => <-.<-.FirstParallel.value;
         secondPar => <-.<-.SecondParallel.value;
       };
       out<NEportLevels={0,3}>;
     };
     GIS.GISMeshInvProject GISMeshInvProject#3<NEx=440.,NEy=458.> {
       in<NEportLevels={3,0}>;
       project_coord {
         InverseTransform => <-.<-.Transform.selectedText;
         GlobalRadius => <-.<-.Radius.value;
         baseLat => <-.<-.BaseLat.value;
         baseLon => <-.<-.BaseLon.value;
         firstPar => <-.<-.FirstParallel.value;
         secondPar => <-.<-.SecondParallel.value;
       };
       out<NEportLevels={0,3}>;
     };
     GIS.GISMeshInvProject GISMeshInvProject#4<NEx=648.,NEy=458.> {
       in<NEportLevels={3,0}>;
       project_coord {
         InverseTransform => <-.<-.Transform.selectedText;
         GlobalRadius => <-.<-.Radius.value;
         baseLat => <-.<-.BaseLat.value;
         baseLon => <-.<-.BaseLon.value;
         firstPar => <-.<-.FirstParallel.value;
         secondPar => <-.<-.SecondParallel.value;
       };
       out<NEportLevels={0,3}>;
     };
     VUIDial Offset<NEx=77.,NEy=154.> {
       parent<NEx=5.,NEy=28.> => <-.UIpanel;
       height<NEx=605.,NEy=28.> = 150;
       Field<NEx=261.,NEy=364.>;
       Up<NEx=342.,NEy=196.>;
       Down<NEx=507.,NEy=196.>;
       ParseDown<NEx=480.,NEy=280.>;
       value<NEportLevels={0,2}> = 0.;
       title<NEx=177.,NEy=196.> = "Longitude Offset";
       x<NEx=155.,NEy=28.> = 100;
       y<NEx=305.,NEy=28.> = 530;
       width<NEx=455.,NEy=28.> = 100;
       min<NEx=455.,NEy=112.> = -180;
       max<NEx=605.,NEy=112.> = 360;
       decimalPoints<NEx=12.,NEy=196.> = 2;
       immediate<NEx=155.,NEy=112.>;
       visible<NEx=5.,NEy=112.>;
       Dial<NEx=44.,NEy=154.> {
         height => 120;
       };
       ParseUp<NEx=286.,NEy=264.>;
     };
   };

};
