/*
			Copyright (c) 2002 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hdf5.v#1 $
*/

flibrary HDF5 <
    disabled => Templates.CONFIG.hdf5_kit_disabled,
    needs_use_lic="GD", needs_edit_lic="DV"
    >
{

library+buffered H5_Modules
<
    build_dir="hdf5",
    build_cmd="$(MAKE)",
    use_src_file=0,
    link_files="-lh5_mods -lhdf5 -lz"
    >
{

module H5read_array {
    string+Iparam filename;
    string+Iparam variable;

    prim+Oparam outArr[];

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5read_array_update";
};

module H5read_field<need_objs="Mesh_Unif Mesh_Rect Mesh_Struct"> {
    string+Iparam      filename;
    string+read+IPort2 h5root = "/";

    // components/variables
    int+IPort2 nodeVars[]; // Node Data components
    int+IPort2 cellVars[]; // Cell Data components

    // crop parameters (arrays are ndim in size)
    long+read+IPort2 min[];
    long+read+IPort2 max[];
    // downsize parameter
    int+read+IPort2 factor[]; // (array is ndim in size)

    // Only for a time dependent field, ignored otherwise
    int+Iparam timeStep = 0;

    // Copy results into a pre-existing field instead of
    // creating a new one. outFld should be connected to
    // the pre-existing field. Big trouble if the pre-existing
    // field is not the right type.
    int+Iparam copyIntoExisting = 0;

    // Type of the field depends on the contents of the file
    //Mesh+Oparam &outFld;
    Mesh+Node_Data_Opt+Cell_Data_Opt+Oparam &outFld;

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5read_field_update";
};

module H5read_time_field<need_objs="Mesh_Unif Mesh_Rect Time_Mesh_Struct Time_Node_Data Time_Cell_Data"> {
    string+Iparam      filename;
    string+read+IPort2 h5root = "/";

    // components/variables
    int+IPort2 nodeVars[]; // Node Data components
    int+IPort2 cellVars[]; // Cell Data components

    // crop parameters (arrays are ndim in size)
    long+read+IPort2 min[];
    long+read+IPort2 max[];
    // downsize parameter
    int+read+IPort2 factor[]; // (array is ndim in size)

    // When you consider all the possible combinations, e.g.
    // Time_Mesh+Node_Data, Mesh+Time_Node_Data, etc., its
    // remarkable how minimal the greatest common denominator is.
    Cells+Xform+Oparam &outFld {
        int nspace;
        long nnodes;
        int nsteps;
        double time[nsteps];
    };

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5read_time_field_update";
};

module H5list_vars {
    string+Iparam      filename;
    string+read+IPort2 h5root = "/";

    // All of the following are outputs.

    // Dimensional information to guide the
    // selection of crop and downsize parameters.
    int+Oparam ndim;
    long+Oparam dims[ndim];

    // Node Data components
    string+Oparam nodeVars[];
    // Cell Data components
    string+Oparam cellVars[];

    // Number of time steps
    int+Oparam timeSteps;

    // Output trigger to help the UI.
    int+Oparam do;

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5list_vars_update";
};

///////////////////

module H5write_array {
    string+Iparam   filename;
    string+Iparam   variable;
    int+read+IPort2 newfile = 1;

    prim+Iparam     inArr[];

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5write_array_update";
};

module H5write_field {
    string+Iparam      filename;
    string+read+IPort2 h5root = "/";
    int+read+IPort2    newfile = 1;
    int+read+IPort2    compress = 0;

    Mesh+Node_Data_Opt+Cell_Data_Opt+Iparam &inFld;

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5write_field_update";
};

module H5write_time_field {
    string+Iparam  filename;
    string+read+IPort2 h5root = "/";
    int+read+IPort2    compress = 0;

    group+Iparam &inFld {
        int nspace;
        long nnodes;
        int nsteps;
        double time[nsteps];
    };

    omethod+notify_val+notify_inst update<status=1> =
        "HDF5write_time_field_update";
};

}; // H5_Modules

library+buffered H5_Macros<compile_subs=0> {

macro Rd_HDF5_Field {

    group Rd_HDF5_Param <NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        string h5root<NEportLevels={1,2}> = "/";

        int+Oparam ndim;
        long+Oparam dims[ndim];

        // Strings to drive the UI ...
        string+Port2 nodeVars[]; // (All) Node Data components
        string+Port2 cellVars[]; // (All) Cell Data components
        // Integer indicies ...
        int+Port2 selNodeVars[]; // Selected Node Data components
        int+Port2 selCellVars[]; // Selected Cell Data components

        // Subset (crop/downsize) parameters
	long+Port2 min<animate=1>[]    => init_array(.ndim,0,0);
	long+Port2 max<animate=1>[]    => .dims-1;
	int+Port2 factor<animate=1>[] => init_array(.ndim,1,1);

	int+Port2 timeSteps = -1;           // Number of steps in file
	int+Port3 timeStep<animate=1> = -1; // step choosen by user

        int trigger<NEportLevels={1,2}>;
    };

    H5list_vars list_vars {
	group &param => <-.Rd_HDF5_Param;
	filename  => param.filename;
	ndim      => param.ndim;
	dims      => param.dims;
	nodeVars  => param.nodeVars;
	cellVars  => param.cellVars;
        timeSteps => param.timeSteps;
    };

    GMOD.parse_v init_params {
        v_commands+nonotify = "
            min    => init_array(.ndim,0,0);
            max    => .dims-1;
            factor => init_array(.ndim,1,1);
            selNodeVars => init_array(array_size(.nodeVars),0,array_size(.nodeVars)-1);
            selCellVars => init_array(array_size(.cellVars),0,array_size(.cellVars)-1);
        ";
        on_inst = 0;
        trigger => list_vars.do;
        relative => <-.Rd_HDF5_Param;
    };

    int timeEnable => is_valid(.Rd_HDF5_Param.timeSteps) &&
                      (.Rd_HDF5_Param.timeSteps>0);

    H5read_field read_field {
	group &param => <-.Rd_HDF5_Param;
        // Note that trigger is a new variable
        int+Iparam trigger => param.trigger;
        filename => param.filename;
	nodeVars => param.selNodeVars;
	cellVars => param.selCellVars;
	min => param.min;
	max => param.max;
	factor => param.factor;
        timeStep  => param.timeStep;

        // This seems redundant, but the +req on trigger
        // isn't respected unless you do this.
        omethod+notify_val+notify_inst update<status=1> =
            "HDF5read_field_update";
    };

    GMOD.instancer instancer {
	Value => panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => Rd_HDF5_UI;
    };
    UImod_panel panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "HDF5 Read Field control panel.";
    };

    macro Rd_HDF5_UI<instanced=0> {
	ilink param => <-.Rd_HDF5_Param;
	ilink panel => <-.panel;

        UIlabel Field_Filename {
            parent => <-.panel;
            label  => "HDF5 filename:";
            y      => 0;
            width  => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => <-.panel;
            y => Field_Filename.y + Field_Filename.height + 5;
            text => <-.param.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton browser_visible {
            parent => <-.panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browser_visible.do;
               input   => <-.<-.browser_visible.do;
               output  =>    <-.visible;
            };
            title = "Read HDF5 Filename";
            searchPattern = "$XP_PATH<0>/data/hdf5/*.h5";
            //searchPattern = "*.h5";
            filename => <-.param.filename;
        };

        //====================================

        UIbutton apply {
            parent => <-.panel;
	    y      => <-.file_name.y + <-.file_name.height + 4;
            width = 100;
            height => <-.file_name.height;
            label = "Read File";
            //active => (array_size(<-.param.selectedVariables) != 0);
            do => param.trigger;
        };

        //====================================

        UIslider time_slider {
            parent => <-.panel;
            y => <-.apply.y + <-.apply.height + 8;
            visible => timeEnable;
            min = 0;
            max+nres => switch( ((param.timeSteps-1)>0)+1,
                                 0,
                                 param.timeSteps-1 );
            value => param.timeStep;
            mode = "integer";
            title = "Time Step";
        };

        //====================================

        // Show the possible node data variables and let the user pick.

        UIoptionBoxLabel  choose_node_vars {
            parent        => <-.panel;
            labels+IPort2 => <-.param.nodeVars;
            &selectedItems+IPort2 => <-.param.selNodeVars;
            UIframe UIpanel { // trick to turn the panel into a frame
                parent => <-.parent;
                x      => <-.x;
                y      => <-.y;
                width  => <-.width;
                height => <-.height + 3;
                visible => (array_size(<-.<-.param.nodeVars) != 0);
            };
            UIlabel {
                y = 2;
                visible   => (array_size(<-.<-.param.nodeVars) != 0);
            };
            title = "Select node data components:";
	    y             => switch( timeEnable+1,
                                     <-.apply.y + <-.apply.height + 5,
                                     <-.time_slider.y + <-.time_slider.height + 12 );
            width         => <-.panel.width;
        };

        //====================================

        // Show the possible cell data variables and let the user pick.

        UIoptionBoxLabel  choose_cell_vars {
            parent        => <-.panel;
            labels+IPort2 => <-.param.cellVars;
            &selectedItems+IPort2 => <-.param.selCellVars;
            UIframe UIpanel { // trick to turn the panel into a frame
                parent => <-.parent;
                x      => <-.x;
                y      => <-.y;
                width  => <-.width;
                height => <-.height + 3;
                visible => (array_size(<-.<-.param.cellVars) != 0);
            };
            UIlabel {
                y = 2;
                visible   => (array_size(<-.<-.param.cellVars) != 0);
            };
            title = "Select cell data components:";
	    y             => choose_node_vars.y + choose_node_vars.height + 4;
            width         => <-.panel.width;
        };

        //====================================

        int+nres sliders_visible => panel.visible && is_valid(param.ndim);

        UIlabel crop_label {
            parent => <-.panel;
            label  => "Crop parameters:";
	    y => choose_cell_vars.y + choose_cell_vars.height + 4;
            width  => 200;
            alignment = 0;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
        };

        UIslider min0_slider {
	    parent => <-.panel;
	    title = "I min";
	    max+nres => param.dims[0]-1;
	    value+nres+IPort2 => param.min[0];
	    mode = 1;
	    y => crop_label.y + crop_label.height;
            width	=> <-.panel.width;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
	};
	min0_slider max0_slider {
	    title = "I max";
	    max+nres => param.dims[0]-1;
	    value+nres+IPort2 => param.max[0];
	    y => <-.min0_slider.y + <-.min0_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
	};

	min0_slider min1_slider {
	    title = "J min";
	    max+nres => param.dims[1]-1;
	    value+nres+IPort2 => param.min[1];
	    y => <-.max0_slider.y + <-.max0_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 1);
	};
	min0_slider max1_slider {
	    title = "J max";
	    max+nres => param.dims[1]-1;
	    value+nres+IPort2 => param.max[1];
	    y => <-.min1_slider.y + <-.min1_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 1);
	};

	min0_slider min2_slider {
	    title = "K min";
	    max+nres => param.dims[2]-1;
	    value+nres+IPort2 => param.min[2];
	    y => <-.max1_slider.y + <-.max1_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 2);
	};
	min0_slider max2_slider {
	    title = "K max";
	    max+nres => param.dims[2]-1;
	    value+nres+IPort2 => param.max[2];
	    y => <-.min2_slider.y + <-.min2_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 2);
	};

        //====================================

        UIlabel downsize_label {
            parent => <-.panel;
            label  => "Downsize parameters:";
	    y      => <-.max2_slider.y + <-.max2_slider.height + 8;
            width  => 200;
            alignment = 0;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
        };

        UIslider factor0_slider {
	    parent => <-.panel;
	    title = "I factor";
	    min = 1;
	    max = 16;
	    value+IPort2 => param.factor[0];
	    mode => 1;
	    y     => <-.downsize_label.y + <-.downsize_label.height;
	    width => <-.panel.width;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
	};
	factor0_slider factor1_slider {
	    title = "J factor";
	    value => param.factor[1];
	    y     => <-.factor0_slider.y + <-.factor0_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 1);
	};
	factor0_slider factor2_slider {
	    title = "K factor";
	    value => param.factor[2];
	    y     => <-.factor1_slider.y + <-.factor1_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 2);
	};

     };

    DataObjectNoTexture obj {
	in => read_field.outFld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => read_field.outFld;
    olink out_obj => obj.obj;
};


macro Rd_HDF5_Time_Field {

    UImod_panel panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "HDF5 Read Field control panel.";
    };

    group Rd_HDF5_Param <NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        string h5root<NEportLevels={1,2}> = "/";

        int+Oparam ndim;
        long+Oparam dims[ndim];

        // Strings to drive the UI ...
        string+Port2 nodeVars[]; // (All) Node Data components
        string+Port2 cellVars[]; // (All) Cell Data components
        // Integer indicies ...
        int+Port2 selNodeVars[]; // Selected Node Data components
        int+Port2 selCellVars[]; // Selected Cell Data components

        // Subset (crop/downsize) parameters
	long+Port2 min<animate=1>[]    => init_array(.ndim,0,0);
	long+Port2 max<animate=1>[]    => .dims-1;
	int+Port2 factor<animate=1>[] => init_array(.ndim,1,1);

	int+Port2 timeSteps = -1;           // Number of steps in file

        int trigger<NEportLevels={1,2}>;
    };

    H5list_vars list_vars {
	group &param => <-.Rd_HDF5_Param;
	filename => param.filename;
	ndim    => param.ndim;
	dims    => param.dims;
	nodeVars => param.nodeVars;
	cellVars => param.cellVars;
        timeSteps => param.timeSteps;
    };

    GMOD.parse_v init_params {
        v_commands+nonotify = "
            min    => init_array(.ndim,0,0);
            max    => .dims-1;
            factor => init_array(.ndim,1,1);
            selNodeVars => init_array(array_size(.nodeVars),0,array_size(.nodeVars)-1);
            selCellVars => init_array(array_size(.cellVars),0,array_size(.cellVars)-1);
        ";
        on_inst = 0;
        trigger => list_vars.do;
        relative => <-.Rd_HDF5_Param;
    };

    int timeEnable => is_valid(.Rd_HDF5_Param.timeSteps) &&
                        (.Rd_HDF5_Param.timeSteps>0);

    H5read_time_field read_field {
	group &param => <-.Rd_HDF5_Param;
        // Note that trigger is a new variable
        int+Iparam trigger => param.trigger;
        filename => param.filename;
	nodeVars => param.selNodeVars;
	cellVars => param.selCellVars;
	min => param.min;
	max => param.max;
	factor => param.factor;

        // This seems redundant, but the +req on trigger
        // isn't respected unless you do this.
        omethod+notify_val+notify_inst update<status=1> =
            "HDF5read_time_field_update";
    };

    GMOD.instancer instancer {
	Value => panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => Rd_HDF5_UI;
    };

    macro Rd_HDF5_UI<instanced=0> {
	ilink param => <-.Rd_HDF5_Param;
	ilink panel => <-.panel;

        UIlabel Field_Filename {
            parent => <-.panel;
            label  => "HDF5 filename:";
            y      => 0;
            width  => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => <-.panel;
            y => Field_Filename.y + Field_Filename.height + 5;
            text => <-.param.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton browser_visible {
            parent => <-.panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browser_visible.do;
               input   => <-.<-.browser_visible.do;
               output  =>    <-.visible;
            };
            title = "Read HDF5 Filename";
            searchPattern = "$XP_PATH<0>/data/hdf5/*.h5";
            //searchPattern = "*.h5";
            filename => <-.param.filename;
        };

        //====================================

        UIbutton apply {
            parent => <-.panel;
	    y      => <-.file_name.y + <-.file_name.height + 4;
            width = 100;
            height => <-.file_name.height;
            label = "Read File";
            //active => (array_size(<-.param.selectedVariables) != 0);
            do => param.trigger;
        };

        //====================================

        UIlabel time_label {
            parent => <-.panel;
            y => <-.apply.y + <-.apply.height + 8;
            visible => is_valid(param.timeSteps) && (param.timeSteps>0);
            label => switch( .visible+1,
                             "<no time steps in file>",
                             str_format( "%d time steps in file",
                                         param.timeSteps ) );
        };

        //====================================

        // Show the possible node data variables and let the user pick.

        UIoptionBoxLabel  choose_node_vars {
            parent        => <-.panel;
            labels+IPort2 => <-.param.nodeVars;
            &selectedItems+IPort2 => <-.param.selNodeVars;
            UIframe UIpanel { // trick to turn the panel into a frame
                parent => <-.parent;
                x      => <-.x;
                y      => <-.y;
                width  => <-.width;
                height => <-.height + 3;
                visible => (array_size(<-.<-.param.nodeVars) != 0);
            };
            UIlabel {
                y = 2;
                visible   => (array_size(<-.<-.param.nodeVars) != 0);
            };
            title = "Select node data components:";
	    y             => <-.time_label.y + <-.time_label.height + 8;
            width         => <-.panel.width;
        };

        //====================================

        // Show the possible cell data variables and let the user pick.

        UIoptionBoxLabel  choose_cell_vars {
            parent        => <-.panel;
            labels+IPort2 => <-.param.cellVars;
            &selectedItems+IPort2 => <-.param.selCellVars;
            UIframe UIpanel { // trick to turn the panel into a frame
                parent => <-.parent;
                x      => <-.x;
                y      => <-.y;
                width  => <-.width;
                height => <-.height + 3;
                visible => (array_size(<-.<-.param.cellVars) != 0);
            };
            UIlabel {
                y = 2;
                visible   => (array_size(<-.<-.param.cellVars) != 0);
            };
            title = "Select cell data components:";
	    y             => choose_node_vars.y + choose_node_vars.height + 4;
            width         => <-.panel.width;
        };


        //====================================

        int+nres sliders_visible => panel.visible && is_valid(param.ndim);

        UIlabel crop_label {
            parent => <-.panel;
            label  => "Crop parameters:";
	    y => choose_cell_vars.y + choose_cell_vars.height + 4;
            width  => 200;
            alignment = 0;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
        };

        UIslider min0_slider {
	    parent => <-.panel;
	    title = "I min";
	    max+nres => param.dims[0]-1;
	    value+nres+IPort2 => param.min[0];
	    mode = 1;
	    y => crop_label.y + crop_label.height;
            width	=> <-.panel.width;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
	};
	min0_slider max0_slider {
	    title = "I max";
	    max+nres => param.dims[0]-1;
	    value+nres+IPort2 => param.max[0];
	    y => <-.min0_slider.y + <-.min0_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
	};

	min0_slider min1_slider {
	    title = "J min";
	    max+nres => param.dims[1]-1;
	    value+nres+IPort2 => param.min[1];
	    y => <-.max0_slider.y + <-.max0_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 1);
	};
	min0_slider max1_slider {
	    title = "J max";
	    max+nres => param.dims[1]-1;
	    value+nres+IPort2 => param.max[1];
	    y => <-.min1_slider.y + <-.min1_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 1);
	};

	min0_slider min2_slider {
	    title = "K min";
	    max+nres => param.dims[2]-1;
	    value+nres+IPort2 => param.min[2];
	    y => <-.max1_slider.y + <-.max1_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 2);
	};
	min0_slider max2_slider {
	    title = "K max";
	    max+nres => param.dims[2]-1;
	    value+nres+IPort2 => param.max[2];
	    y => <-.min2_slider.y + <-.min2_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 2);
	};

        //====================================

        UIlabel downsize_label {
            parent => <-.panel;
            label  => "Downsize parameters:";
	    y      => <-.max2_slider.y + <-.max2_slider.height + 8;
            width  => 200;
            alignment = 0;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
        };

        UIslider factor0_slider {
	    parent => <-.panel;
	    title = "I factor";
	    min = 1;
	    max = 16;
	    value+IPort2 => param.factor[0];
	    mode => 1;
	    y     => <-.downsize_label.y + <-.downsize_label.height;
	    width => <-.panel.width;
	    visible+nres => <-.sliders_visible && (param.ndim > 0);
	};
	factor0_slider factor1_slider {
	    title = "J factor";
	    value => param.factor[1];
	    y     => <-.factor0_slider.y + <-.factor0_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 1);
	};
	factor0_slider factor2_slider {
	    title = "K factor";
	    value => param.factor[2];
	    y     => <-.factor1_slider.y + <-.factor1_slider.height + 4;
	    visible+nres => <-.sliders_visible && (param.ndim > 2);
	};

     };

    olink out_fld<export_all=2> => read_field.outFld;
};

macro Wr_HDF5_Field {
    ilink in_field<export_all=1>;

    group Wr_HDF5_Param <NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        string h5root<NEportLevels={1,2}> = "/";
        int compress<NEportLevels={1,2}>;
        int trigger<NEportLevels={1,2}>;
    };

    H5write_field write_field {
	group &param => <-.Wr_HDF5_Param;
        // Note that trigger is a new variable
        int+Iparam trigger => param.trigger;
        filename => param.filename;
        h5root   => param.h5root;
        compress => param.compress;
        inFld    => <-.in_field;

        // This seems redundant, but the +req on trigger
        // isn't respected unless you do this.
        omethod+notify_val+notify_inst update<status=1> =
            "HDF5write_field_update";
    };

    GMOD.instancer instancer {
	Value => panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => Wr_HDF5_UI;
    };
    UImod_panel panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "HDF5 Write Field control panel.";
    };

    macro Wr_HDF5_UI<instanced=0> {
	ilink param => <-.Wr_HDF5_Param;
	ilink panel => <-.panel;

        UIlabel Field_Filename {
            parent => <-.panel;
            label  => "HDF5 filename:";
            y      => 0;
            width  => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => <-.panel;
            y => <-.Field_Filename.y + <-.Field_Filename.height + 5;
            text => <-.param.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton browser_visible {
            parent => <-.panel;
            x => <-.file_name.x + <-.file_name.width + 5;
            y => <-.file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browser_visible.do;
               input   => <-.<-.browser_visible.do;
               output  =>    <-.visible;
            };
            title = "Write HDF5 Filename";
            searchPattern = "$XP_PATH<0>/data/hdf5/*.h5";
            //searchPattern = "*.h5";
            filename => <-.param.filename;
        };

        //====================================

        UIbutton apply {
            parent => <-.panel;
	    y      => <-.file_name.y + <-.file_name.height + 4;
            width = 100;
            height => <-.file_name.height;
            label = "Write File";
            do => param.trigger;
        };

        UItoggle compress {
            parent => <-.panel;
            label  = "Write Compressed";
	    y      => <-.apply.y + <-.apply.height + 8;
            width  = 200;
            set    => param.compress;
        };
    };
};

macro Wr_HDF5_Time_Field {
    ilink in_field<export_all=1>;

    group Wr_HDF5_Param <NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        string h5root<NEportLevels={1,2}> = "/";
        int compress<NEportLevels={1,2}>;
        int trigger<NEportLevels={1,2}>;
    };

    H5write_time_field write_field {
	group &param => <-.Wr_HDF5_Param;
        // Note that trigger is a new variable
        int+Iparam trigger => param.trigger;
        filename => param.filename;
        h5root   => param.h5root;
        compress => param.compress;
        inFld    => <-.in_field;

        // This seems redundant, but the +req on trigger
        // isn't respected unless you do this.
        omethod+notify_val+notify_inst update<status=1> =
            "HDF5write_time_field_update";
    };

    GMOD.instancer instancer {
	Value => panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => Wr_HDF5_UI;
    };
    UImod_panel panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "HDF5 Write Field control panel.";
    };

    macro Wr_HDF5_UI<instanced=0> {
	ilink param => <-.Wr_HDF5_Param;
	ilink panel => <-.panel;

        UIlabel Field_Filename {
            parent => <-.panel;
            label  => "HDF5 filename:";
            y      => 0;
            width  => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => <-.panel;
            y => Field_Filename.y + Field_Filename.height + 5;
            text => <-.param.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton browser_visible {
            parent => <-.panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browser_visible.do;
               input   => <-.<-.browser_visible.do;
               output  =>    <-.visible;
            };
            title = "Write HDF5 Filename";
            searchPattern = "$XP_PATH<0>/data/hdf5/*.h5";
            filename => <-.param.filename;
        };

        //====================================

        UIbutton apply {
            parent => <-.panel;
	    y      => <-.file_name.y + <-.file_name.height + 4;
            width = 100;
            height => <-.file_name.height;
            label = "Write File";
            do => param.trigger;
        };

        UItoggle compress {
            parent => <-.panel;
            label  = "Write Compressed";
	    y      => <-.apply.y + <-.apply.height + 8;
            width  = 200;
            set    => param.compress;
        };
    };
};

}; // Macros

}; // HDF5
